/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.dataviz.chart;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.jquery.core.behavior.ListModelBehavior;
import com.googlecode.wicket.jquery.core.converter.IJsonConverter;
import com.googlecode.wicket.jquery.core.converter.JsonConverter;
import com.googlecode.wicket.kendo.ui.KendoBehaviorFactory;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.dataviz.chart.ChartBehavior;
import com.googlecode.wicket.kendo.ui.dataviz.chart.IChartListener;
import com.googlecode.wicket.kendo.ui.dataviz.chart.series.Series;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class Chart<T>
extends JQueryGenericContainer<List<T>>
implements IChartListener {
    private static final long serialVersionUID = 1L;
    protected final Options options;
    protected final List<Series> series;
    private final IJsonConverter<T> converter;
    private AjaxCallbackBehavior modelBehavior;

    public Chart(String id, List<Series> series) {
        this(id, series, new Options(), (IJsonConverter<T>)new JsonConverter());
    }

    public Chart(String id, List<Series> series, Options options) {
        this(id, series, options, (IJsonConverter<T>)new JsonConverter());
    }

    public Chart(String id, List<Series> series, IJsonConverter<T> converter) {
        this(id, series, new Options(), converter);
    }

    public Chart(String id, List<Series> series, Options options, IJsonConverter<T> converter) {
        super(id);
        this.series = series;
        this.options = options;
        this.converter = converter;
    }

    public Chart(String id, List<T> data, List<Series> series) {
        this(id, Model.ofList(data), series, new Options());
    }

    public Chart(String id, List<T> data, List<Series> series, Options options) {
        this(id, (IModel<List<T>>)Model.ofList(data), series, options, (IJsonConverter<T>)new JsonConverter());
    }

    public Chart(String id, List<T> data, List<Series> series, IJsonConverter<T> converter) {
        this(id, Model.ofList(data), series, new Options(), converter);
    }

    public Chart(String id, List<T> data, List<Series> series, Options options, IJsonConverter<T> converter) {
        this(id, Model.ofList(data), series, options, converter);
    }

    public Chart(String id, IModel<List<T>> model, List<Series> series) {
        this(id, model, series, new Options(), (IJsonConverter<T>)new JsonConverter());
    }

    public Chart(String id, IModel<List<T>> model, List<Series> series, Options options) {
        this(id, model, series, options, (IJsonConverter<T>)new JsonConverter());
    }

    public Chart(String id, IModel<List<T>> model, List<Series> series, IJsonConverter<T> converter) {
        this(id, model, series, new Options(), converter);
    }

    public Chart(String id, IModel<List<T>> model, List<Series> series, Options options, IJsonConverter<T> converter) {
        super(id, model);
        this.series = series;
        this.options = options;
        this.converter = converter;
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoChart");
    }

    public final void show(IPartialPageRequestHandler handler) {
        this.onShow(handler);
        KendoBehaviorFactory.show(handler, (Component)this);
    }

    public final void hide(IPartialPageRequestHandler handler) {
        KendoBehaviorFactory.hide(handler, (Component)this);
        this.onHide(handler);
    }

    public void reload(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this});
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); }", this.widget()));
    }

    public final List<Series> getSeries() {
        return this.series;
    }

    protected final CharSequence getCallbackUrl() {
        return this.modelBehavior.getCallbackUrl();
    }

    protected final IJsonConverter<T> getConverter() {
        return this.converter;
    }

    @Override
    public boolean isSeriesClickEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newListModelBehavior(this.getModel(), this.getConverter());
        this.add(new Behavior[]{this.modelBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    protected void onConfigure(KendoDataSource dataSource) {
        String selector = IJQueryWidget.JQueryWidget.getSelector((Component)this);
        dataSource.set("requestStart", String.format("function () { kendo.ui.progress(jQuery('%s'), true); }", selector));
        dataSource.set("requestEnd", String.format("function () { kendo.ui.progress(jQuery('%s'), false); }", selector));
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public void onShow(IPartialPageRequestHandler handler) {
    }

    public void onHide(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onSeriesClick(AjaxRequestTarget target, String seriesName, String seriesField, String category, long value) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ChartBehavior(selector, this.options, this.series, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getProviderUrl() {
                return Chart.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(KendoDataSource dataSource) {
                Chart.this.onConfigure(dataSource);
            }
        };
    }

    protected AjaxCallbackBehavior newListModelBehavior(IModel<List<T>> model, IJsonConverter<T> converter) {
        return new ListModelBehavior(model, converter);
    }
}

