/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.authorization.server;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicy;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleList;
import com.okta.sdk.resource.policy.PolicyRuleConditions;
import com.okta.sdk.resource.policy.PolicyType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAuthorizationServerPolicy
extends AbstractInstanceResource<AuthorizationServerPolicy>
implements AuthorizationServerPolicy {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ResourceReference<PolicyRuleConditions> conditionsProperty = new ResourceReference<PolicyRuleConditions>("conditions", PolicyRuleConditions.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty descriptionProperty = new StringProperty("description");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final IntegerProperty priorityProperty = new IntegerProperty("priority");
    private static final EnumProperty<AuthorizationServerPolicy.StatusEnum> statusProperty = new EnumProperty<AuthorizationServerPolicy.StatusEnum>("status", AuthorizationServerPolicy.StatusEnum.class);
    private static final BooleanProperty systemProperty = new BooleanProperty("system");
    private static final EnumProperty<PolicyType> typeProperty = new EnumProperty<PolicyType>("type", PolicyType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAuthorizationServerPolicy.createPropertyDescriptorMap(embeddedProperty, linksProperty, conditionsProperty, createdProperty, descriptionProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultAuthorizationServerPolicy(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthorizationServerPolicy(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AuthorizationServerPolicy.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public PolicyRuleConditions getConditions() {
        return this.getResourceProperty(conditionsProperty);
    }

    public AuthorizationServerPolicy setConditions(PolicyRuleConditions conditions) {
        this.setProperty(conditionsProperty, (Object)conditions);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getDescription() {
        return this.getString(descriptionProperty);
    }

    public AuthorizationServerPolicy setDescription(String description) {
        this.setProperty(descriptionProperty, (Object)description);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public AuthorizationServerPolicy setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public Integer getPriority() {
        return this.getIntProperty(priorityProperty);
    }

    public AuthorizationServerPolicy setPriority(Integer priority) {
        this.setProperty(priorityProperty, (Object)priority);
        return this;
    }

    public AuthorizationServerPolicy.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public AuthorizationServerPolicy setStatus(AuthorizationServerPolicy.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public Boolean getSystem() {
        return this.getBoolean(systemProperty);
    }

    public AuthorizationServerPolicy setSystem(Boolean system) {
        this.setProperty(systemProperty, (Object)system);
        return this;
    }

    public PolicyType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public AuthorizationServerPolicy setType(PolicyType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public AuthorizationServerPolicyRule getPolicyRule(String authServerId, String ruleId) {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "", AuthorizationServerPolicyRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate(String authServerId) {
        String policyId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyRule createPolicyRule(String authServerId, AuthorizationServerPolicyRule policyRule) {
        String policyId = this.getId();
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules", policyRule, this, AuthorizationServerPolicyRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public AuthorizationServerPolicy update(String authServerId) {
        String policyId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public void delete(String authServerId) {
        String policyId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyRuleList listPolicyRules(String authServerId) {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules", AuthorizationServerPolicyRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void activate(String authServerId) {
        String policyId = this.getId();
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deletePolicyRule(String authServerId, String ruleId) {
        String policyId = this.getId();
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "", queryArgs, (Map<String, List<String>>)headers);
    }
}

