/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.lib.WebClientBuilder;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.AMSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMSessionRestClient
implements RestClient {
    private static final long serialVersionUID = 17371816842780L;
    protected static final Logger LOG = LoggerFactory.getLogger(AMSessionRestClient.class);
    protected static final List<?> JAX_RS_PROVIDERS = List.of(new JacksonJsonProvider(((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build()));
    protected final List<NetworkService> instances;

    protected AMSessionRestClient(List<NetworkService> instances) {
        this.instances = instances;
    }

    protected abstract String getActuatorEndpoint();

    public abstract List<AMSession> list();

    public void delete(String key) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
        try {
            Response response = WebClientBuilder.build((String)this.getActuatorEndpoint(), (String)SyncopeWebApplication.get().getAnonymousUser(), (String)SyncopeWebApplication.get().getAnonymousKey(), List.of()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE).path((Object)key).delete();
            if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                LOG.error("Unexpected response when deleting SSO Session {} from {}: {}", new Object[]{key, this.getActuatorEndpoint(), response.getStatus()});
                sce.getElements().add("Unexpected response code: " + response.getStatus());
            }
        }
        catch (Exception e) {
            LOG.error("Could not delete SSO Session {} from {}", new Object[]{key, this.getActuatorEndpoint(), e});
            sce.getElements().add("Unexpected error: " + e.getMessage());
        }
        if (!sce.getElements().isEmpty()) {
            throw sce;
        }
    }
}

