/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.flowable.common.engine.api.FlowableException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.listener.BackOffHandler;
import org.springframework.kafka.listener.ContainerPartitionPausingBackOffManagerFactory;
import org.springframework.kafka.listener.ContainerPausingBackOffHandler;
import org.springframework.kafka.listener.KafkaBackOffManagerFactory;
import org.springframework.kafka.listener.ListenerContainerPauseService;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.ClassUtils;

class KafkaBackOffManagerUtils {
    public static boolean SPRING_KAFKA_2_9_PRESENT = ClassUtils.isPresent((String)"org.springframework.kafka.listener.ContainerPartitionPausingBackOffManagerFactory", null);

    KafkaBackOffManagerUtils() {
    }

    public static KafkaBackOffManagerFactory createKafkaBackoffManagerFactory(KafkaListenerEndpointRegistry endpointRegistry, ApplicationContext applicationContext, Supplier<TaskScheduler> taskSchedulerSupplier) {
        if (SPRING_KAFKA_2_9_PRESENT) {
            return SpringKafka2_9.createBackOffManagerFactory(endpointRegistry, applicationContext, taskSchedulerSupplier);
        }
        return SpringKafkaPre2_9.createBackOffManagerFactory(endpointRegistry, applicationContext);
    }

    private static class SpringKafkaPre2_9 {
        private SpringKafkaPre2_9() {
        }

        private static KafkaBackOffManagerFactory createBackOffManagerFactory(KafkaListenerEndpointRegistry endpointRegistry, ApplicationContext applicationContext) {
            try {
                Class backOfManagerFactory2_7 = ClassUtils.forName((String)"org.springframework.kafka.listener.PartitionPausingBackOffManagerFactory", null);
                KafkaBackOffManagerFactory backOffManagerFactory = (KafkaBackOffManagerFactory)backOfManagerFactory2_7.getConstructor(ListenerContainerRegistry.class).newInstance(endpointRegistry);
                if (backOffManagerFactory instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)backOffManagerFactory).setApplicationContext(applicationContext);
                }
                return backOffManagerFactory;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new FlowableException("Failed to create KafkaBackOffManagerFactory with Spring Kafka prior to 2.9.x", (Throwable)ex);
            }
        }
    }

    private static class SpringKafka2_9 {
        private SpringKafka2_9() {
        }

        private static KafkaBackOffManagerFactory createBackOffManagerFactory(KafkaListenerEndpointRegistry endpointRegistry, ApplicationContext applicationContext, Supplier<TaskScheduler> taskSchedulerSupplier) {
            ContainerPartitionPausingBackOffManagerFactory containerBackOffManagerFactory = new ContainerPartitionPausingBackOffManagerFactory((ListenerContainerRegistry)endpointRegistry, applicationContext);
            containerBackOffManagerFactory.setBackOffHandler((BackOffHandler)new ContainerPausingBackOffHandler(new ListenerContainerPauseService((ListenerContainerRegistry)endpointRegistry, taskSchedulerSupplier.get())));
            return containerBackOffManagerFactory;
        }
    }
}

