/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.model.TriStateBoolean;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendTicketGrantingTicketAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTicketGrantingTicketAction.class);
    private final TicketRegistry ticketRegistry;
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final SingleSignOnParticipationStrategy singleSignOnParticipationStrategy;

    protected Event doExecute(RequestContext context) throws Exception {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String ticketGrantingTicketValueFromCookie = WebUtils.getTicketGrantingTicketIdFrom((MutableAttributeMap)context.getFlowScope());
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId)) {
            LOGGER.debug("No ticket-granting ticket is found in the context.");
            return this.success();
        }
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().requestContext(context).build();
        if (WebUtils.isAuthenticatingAtPublicWorkstation((RequestContext)context)) {
            LOGGER.info("Authentication is at a public workstation. SSO cookie will not be generated");
        } else if (this.singleSignOnParticipationStrategy.supports(ssoRequest)) {
            boolean createCookie;
            boolean bl = createCookie = this.singleSignOnParticipationStrategy.isCreateCookieOnRenewedAuthentication(ssoRequest) == TriStateBoolean.TRUE || this.singleSignOnParticipationStrategy.isParticipating(ssoRequest);
            if (createCookie) {
                LOGGER.debug("Setting ticket-granting cookie for current session linked to [{}].", (Object)ticketGrantingTicketId);
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
                HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
                this.ticketGrantingTicketCookieGenerator.addCookie(request, response, CookieRetrievingCookieGenerator.isRememberMeAuthentication((RequestContext)context).booleanValue(), ticketGrantingTicketId);
            } else {
                LOGGER.info("Authentication session is renewed but CAS is not configured to create the SSO session. SSO cookie will not be generated. Subsequent requests will be challenged for credentials.");
            }
        }
        if (ticketGrantingTicketValueFromCookie != null && !ticketGrantingTicketId.equals(ticketGrantingTicketValueFromCookie)) {
            LOGGER.debug("Ticket-granting ticket from ticket-granting cookie does not match the ticket-granting ticket from context");
            this.ticketRegistry.deleteTicket(ticketGrantingTicketValueFromCookie);
        }
        return this.success();
    }

    @Generated
    public SendTicketGrantingTicketAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator, SingleSignOnParticipationStrategy singleSignOnParticipationStrategy) {
        this.ticketRegistry = ticketRegistry;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.singleSignOnParticipationStrategy = singleSignOnParticipationStrategy;
    }
}

