/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import lombok.Generated;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class TicketRegistryHealthIndicator
extends AbstractHealthIndicator {
    private final TicketRegistry registryState;
    private final int serviceTicketCountWarnThreshold;
    private final int sessionCountWarnThreshold;

    protected void doHealthCheck(Health.Builder builder) {
        builder.withDetail("name", (Object)((Object)((Object)this)).getClass().getSimpleName());
        long sessionCount = this.registryState.sessionCount();
        long ticketCount = this.registryState.serviceTicketCount();
        if (sessionCount == Integer.MIN_VALUE || ticketCount == Integer.MIN_VALUE) {
            String msg = String.format("Ticket registry %s reports unknown session and/or ticket counts.", this.registryState.getClass().getName());
            TicketRegistryHealthIndicator.buildHealthCheckStatus(builder.unknown(), sessionCount, ticketCount, msg);
            return;
        }
        if (this.sessionCountWarnThreshold > -1 && sessionCount > (long)this.sessionCountWarnThreshold) {
            String msg = String.format("Session count (%s) is above threshold %s. ", sessionCount, this.sessionCountWarnThreshold);
            TicketRegistryHealthIndicator.buildHealthCheckStatus(builder.status("WARN"), sessionCount, ticketCount, msg);
            return;
        }
        if (this.serviceTicketCountWarnThreshold > -1 && ticketCount > (long)this.serviceTicketCountWarnThreshold) {
            String msg = String.format("Service ticket count (%s) is above threshold %s.", ticketCount, this.serviceTicketCountWarnThreshold);
            TicketRegistryHealthIndicator.buildHealthCheckStatus(builder.status("WARN"), sessionCount, ticketCount, msg);
            return;
        }
        TicketRegistryHealthIndicator.buildHealthCheckStatus(builder.up(), sessionCount, ticketCount, "OK");
    }

    private static void buildHealthCheckStatus(Health.Builder builder, long sessionCount, long ticketCount, String msg) {
        builder.withDetail("sessionCount", (Object)sessionCount).withDetail("ticketCount", (Object)ticketCount).withDetail("message", (Object)msg);
    }

    @Generated
    public TicketRegistryHealthIndicator(TicketRegistry registryState, int serviceTicketCountWarnThreshold, int sessionCountWarnThreshold) {
        this.registryState = registryState;
        this.serviceTicketCountWarnThreshold = serviceTicketCountWarnThreshold;
        this.sessionCountWarnThreshold = sessionCountWarnThreshold;
    }
}

