/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GroovyScriptMultifactorAuthenticationProviderSelector
implements MultifactorAuthenticationProviderSelector {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptMultifactorAuthenticationProviderSelector.class);
    private final transient WatchableGroovyScriptResource watchableScript;

    public GroovyScriptMultifactorAuthenticationProviderSelector(Resource resource) {
        this.watchableScript = new WatchableGroovyScriptResource(resource);
    }

    public MultifactorAuthenticationProvider resolve(Collection<MultifactorAuthenticationProvider> providers, RegisteredService service, Principal principal) {
        Object[] args = new Object[]{service, principal, providers, LOGGER};
        LOGGER.debug("Invoking Groovy script with service=[{}], principal=[{}], providers=[{}]", new Object[]{service, principal, providers});
        String provider = (String)this.watchableScript.execute(args, String.class);
        if (StringUtils.isBlank((CharSequence)provider)) {
            LOGGER.debug("Multifactor provider selection script did not return a provider id");
            return null;
        }
        return providers.stream().filter(p -> p.getId().equals(provider)).findFirst().orElse(null);
    }
}

