/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor.multitenant;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AbstractAsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareAcquireAsyncJobsDueRunnable;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareAcquireTimerJobsRunnable;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutorFactory;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareExecuteAsyncRunnableFactory;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareResetExpiredJobsRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorPerTenantAsyncExecutor
implements TenantAwareAsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorPerTenantAsyncExecutor.class);
    protected TenantInfoHolder tenantInfoHolder;
    protected TenantAwareAsyncExecutorFactory tenantAwareAyncExecutorFactory;
    protected AsyncExecutor nullTenantIdAsyncExecutor;
    protected Map<String, AsyncExecutor> tenantExecutors = new ConcurrentHashMap<String, AsyncExecutor>();
    protected JobServiceConfiguration jobServiceConfiguration;
    protected boolean active;
    protected boolean autoActivate;

    public ExecutorPerTenantAsyncExecutor(TenantInfoHolder tenantInfoHolder) {
        this(tenantInfoHolder, null);
    }

    public ExecutorPerTenantAsyncExecutor(TenantInfoHolder tenantInfoHolder, TenantAwareAsyncExecutorFactory tenantAwareAyncExecutorFactory) {
        this.tenantInfoHolder = tenantInfoHolder;
        this.tenantAwareAyncExecutorFactory = tenantAwareAyncExecutorFactory;
    }

    @Override
    public Set<String> getTenantIds() {
        return this.tenantExecutors.keySet();
    }

    @Override
    public void addTenantAsyncExecutor(String tenantId, boolean startExecutor) {
        AbstractAsyncExecutor defaultAsyncJobExecutor;
        AsyncExecutor tenantExecutor = null;
        if (this.tenantAwareAyncExecutorFactory == null) {
            defaultAsyncJobExecutor = new DefaultAsyncJobExecutor();
            defaultAsyncJobExecutor.setTenantId(tenantId);
            tenantExecutor = defaultAsyncJobExecutor;
        } else {
            tenantExecutor = this.tenantAwareAyncExecutorFactory.createAsyncExecutor(tenantId);
        }
        tenantExecutor.setJobServiceConfiguration(this.jobServiceConfiguration);
        if (tenantExecutor instanceof AbstractAsyncExecutor) {
            defaultAsyncJobExecutor = (AbstractAsyncExecutor)tenantExecutor;
            defaultAsyncJobExecutor.setAsyncJobsDueRunnable(new TenantAwareAcquireAsyncJobsDueRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setTimerJobRunnable(new TenantAwareAcquireTimerJobsRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId, defaultAsyncJobExecutor.getMoveTimerExecutorPoolSize()));
            defaultAsyncJobExecutor.setExecuteAsyncRunnableFactory(new TenantAwareExecuteAsyncRunnableFactory(this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setResetExpiredJobsRunnable(new TenantAwareResetExpiredJobsRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
        }
        if (tenantId != null) {
            this.tenantExecutors.put(tenantId, tenantExecutor);
        } else {
            this.nullTenantIdAsyncExecutor = tenantExecutor;
        }
        if (startExecutor) {
            this.startTenantExecutor(tenantId);
        }
    }

    @Override
    public AsyncExecutor getTenantAsyncExecutor(String tenantId) {
        if (tenantId != null) {
            return this.tenantExecutors.get(tenantId);
        }
        return this.nullTenantIdAsyncExecutor;
    }

    @Override
    public void removeTenantAsyncExecutor(String tenantId) {
        this.shutdownTenantExecutor(tenantId);
        if (tenantId != null) {
            this.tenantExecutors.remove(tenantId);
        } else {
            this.nullTenantIdAsyncExecutor = null;
        }
    }

    protected AsyncExecutor determineAsyncExecutor() {
        String currentTenantId = this.tenantInfoHolder.getCurrentTenantId();
        if (currentTenantId != null) {
            return this.tenantExecutors.get(currentTenantId);
        }
        return this.nullTenantIdAsyncExecutor;
    }

    @Override
    public boolean executeAsyncJob(JobInfo job) {
        return this.determineAsyncExecutor().executeAsyncJob(job);
    }

    @Override
    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setJobServiceConfiguration(jobServiceConfiguration);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setJobServiceConfiguration(jobServiceConfiguration);
        }
    }

    @Override
    public JobServiceConfiguration getJobServiceConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoActivate() {
        return this.autoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.autoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void start() {
        for (String tenantId : this.tenantExecutors.keySet()) {
            this.startTenantExecutor(tenantId);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.startTenantExecutor(null);
        }
        this.active = true;
    }

    protected void startTenantExecutor(String tenantId) {
        this.tenantInfoHolder.setCurrentTenantId(tenantId);
        if (tenantId != null) {
            this.tenantExecutors.get(tenantId).start();
        } else if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.start();
        }
        this.tenantInfoHolder.clearCurrentTenantId();
    }

    @Override
    public synchronized void shutdown() {
        for (String tenantId : this.tenantExecutors.keySet()) {
            this.shutdownTenantExecutor(tenantId);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.shutdownTenantExecutor(null);
        }
        this.active = false;
    }

    protected void shutdownTenantExecutor(String tenantId) {
        LOGGER.info("Shutting down async executor for tenant {}", (Object)tenantId);
        this.tenantInfoHolder.setCurrentTenantId(tenantId);
        if (tenantId != null) {
            this.tenantExecutors.get(tenantId).shutdown();
        } else if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.shutdown();
        }
        this.tenantInfoHolder.clearCurrentTenantId();
    }

    @Override
    public String getLockOwner() {
        return this.determineAsyncExecutor().getLockOwner();
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.determineAsyncExecutor().getTimerLockTimeInMillis();
    }

    @Override
    public void setTimerLockTimeInMillis(int lockTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setTimerLockTimeInMillis(lockTimeInMillis);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setTimerLockTimeInMillis(lockTimeInMillis);
        }
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.determineAsyncExecutor().getAsyncJobLockTimeInMillis();
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int lockTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setAsyncJobLockTimeInMillis(lockTimeInMillis);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setAsyncJobLockTimeInMillis(lockTimeInMillis);
        }
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultTimerJobAcquireWaitTimeInMillis();
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int waitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultTimerJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setDefaultTimerJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultAsyncJobAcquireWaitTimeInMillis();
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int waitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultAsyncJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setDefaultAsyncJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultQueueSizeFullWaitTimeInMillis();
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultQueueSizeFullWaitTimeInMillis(defaultQueueSizeFullWaitTimeInMillis);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setDefaultQueueSizeFullWaitTimeInMillis(defaultQueueSizeFullWaitTimeInMillis);
        }
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.determineAsyncExecutor().getMaxAsyncJobsDuePerAcquisition();
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxJobs) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setMaxAsyncJobsDuePerAcquisition(maxJobs);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setMaxAsyncJobsDuePerAcquisition(maxJobs);
        }
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.determineAsyncExecutor().getMaxTimerJobsPerAcquisition();
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxJobs) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setMaxTimerJobsPerAcquisition(maxJobs);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setMaxTimerJobsPerAcquisition(maxJobs);
        }
    }

    @Override
    @Deprecated
    public int getRetryWaitTimeInMillis() {
        return this.determineAsyncExecutor().getRetryWaitTimeInMillis();
    }

    @Override
    @Deprecated
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setRetryWaitTimeInMillis(retryWaitTimeInMillis);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setRetryWaitTimeInMillis(retryWaitTimeInMillis);
        }
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return this.determineAsyncExecutor().getResetExpiredJobsInterval();
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setResetExpiredJobsInterval(resetExpiredJobsInterval);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setResetExpiredJobsInterval(resetExpiredJobsInterval);
        }
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.determineAsyncExecutor().getResetExpiredJobsPageSize();
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setResetExpiredJobsPageSize(resetExpiredJobsPageSize);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setResetExpiredJobsPageSize(resetExpiredJobsPageSize);
        }
    }

    @Override
    public AsyncTaskExecutor getTaskExecutor() {
        AsyncExecutor asyncExecutor = this.determineAsyncExecutor();
        if (asyncExecutor == null) {
            return null;
        }
        return asyncExecutor.getTaskExecutor();
    }

    @Override
    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            if (asyncExecutor.getTaskExecutor() != null) continue;
            asyncExecutor.setTaskExecutor(taskExecutor);
        }
        if (this.nullTenantIdAsyncExecutor != null) {
            this.nullTenantIdAsyncExecutor.setTaskExecutor(taskExecutor);
        }
    }
}

