/*
 * Decompiled with CFR 0.152.
 */
package com.tc.runtime;

import com.tc.runtime.MemoryUsage;

class Jdk15MemoryUsage
implements MemoryUsage {
    private final long max;
    private final long free;
    private final long used;
    private final int usedPercentage;
    private final String desc;
    private final long collectionCount;
    private final long collectionTime;

    public Jdk15MemoryUsage(java.lang.management.MemoryUsage stats, String desc, long collectionCount, long collectionTime) {
        long statsMax = stats.getMax();
        this.max = statsMax <= 0L ? stats.getCommitted() : statsMax;
        this.used = stats.getUsed();
        this.free = this.max - this.used;
        this.usedPercentage = (int)(this.used * 100L / this.max);
        this.desc = desc;
        this.collectionCount = collectionCount;
        this.collectionTime = collectionTime;
    }

    public Jdk15MemoryUsage(java.lang.management.MemoryUsage usage, String desc) {
        this(usage, desc, -1L, -1L);
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public long getFreeMemory() {
        return this.free;
    }

    @Override
    public int getUsedPercentage() {
        return this.usedPercentage;
    }

    @Override
    public long getMaxMemory() {
        return this.max;
    }

    @Override
    public long getUsedMemory() {
        return this.used;
    }

    public String toString() {
        return "Jdk15MemoryUsage ( max = " + this.max + ", used = " + this.used + ", free = " + this.free + ", used % = " + this.usedPercentage + ", collectionCount = " + this.collectionCount + " )";
    }

    @Override
    public long getCollectionCount() {
        return this.collectionCount;
    }

    @Override
    public long getCollectionTime() {
        return this.collectionTime;
    }
}

