/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ServerID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;

public class TCGroupHandshakeMessage
extends DSOMessageBase {
    private static final byte MESSAGE_TYPE = 1;
    private static final byte NODE_ID = 2;
    private static final byte HANDSHAKE_MESSAGE_ID = 3;
    private static final byte VERSION_ID = 4;
    private static final byte WEIGHTS_ID = 5;
    private static final int HANDSHAKE_ACK = 2;
    private static final int HANDSHAKE_OK = 1;
    private static final int HANDSHAKE_DENY = 0;
    private byte messageType;
    private ServerID nodeID;
    private int message;
    private String version;
    private long[] weights;

    public TCGroupHandshakeMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public TCGroupHandshakeMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBufferInputStream data) {
        super(sessionID, monitor, channel, header, data);
    }

    public void initializeAck() {
        this.messageType = (byte)3;
        this.message = 2;
    }

    public void initializeOk() {
        this.messageType = (byte)3;
        this.message = 1;
    }

    public void initializeDeny() {
        this.messageType = (byte)3;
        this.message = 0;
    }

    public boolean isOkMessage() {
        Assert.eval(this.messageType == 3);
        return this.message == 1;
    }

    public boolean isAckMessage() {
        Assert.eval(this.messageType == 3);
        return this.message == 2;
    }

    public ServerID getNodeID() {
        Assert.eval(this.messageType == 2);
        return this.nodeID;
    }

    public void initializeNodeID(ServerID aNodeID, String ver, long[] weightsArray) {
        this.messageType = (byte)2;
        this.nodeID = aNodeID;
        this.version = ver;
        this.weights = weightsArray;
    }

    public String getVersion() {
        return this.version;
    }

    public long[] getWeights() {
        return this.weights;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.messageType);
        switch (this.messageType) {
            case 2: {
                this.putNVPair((byte)4, this.version);
                this.putNVPair((byte)5, this.weights.length);
                for (long weight : this.weights) {
                    this.getOutputStream().writeLong(weight);
                }
                this.putNVPair((byte)2, this.nodeID);
                return;
            }
            case 3: {
                this.putNVPair((byte)3, this.message);
                return;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.messageType = this.getByteValue();
                return true;
            }
            case 2: {
                this.nodeID = (ServerID)this.getNodeIDValue();
                return true;
            }
            case 3: {
                this.message = this.getIntValue();
                return true;
            }
            case 4: {
                this.version = this.getStringValue();
                return true;
            }
            case 5: {
                this.weights = new long[this.getIntValue()];
                for (int i = 0; i < this.weights.length; ++i) {
                    this.weights[i] = this.getLongValue();
                }
                return true;
            }
        }
        return false;
    }
}

