/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.interaction.draggable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.interaction.draggable.IDraggableListener;
import com.googlecode.wicket.kendo.ui.interaction.droppable.DroppableBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;

public class DraggableBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoDraggable";
    public static final String CSS_HIDE = "kendoDraggable-hide";
    public static final String CSS_CLONE = "kendoDraggable-clone";
    public static final String FCN_HINT = "function(element) { return element.clone().addClass('kendoDraggable-clone'); }";
    private final IDraggableListener listener;
    private JQueryAjaxBehavior onDragStartAjaxBehavior;
    private JQueryAjaxBehavior onDragStopAjaxBehavior = null;
    private JQueryAjaxBehavior onDragCancelAjaxBehavior = null;
    private Component component = null;

    public DraggableBehavior(IDraggableListener listener) {
        this(null, new Options(), listener);
    }

    public DraggableBehavior(Options options, IDraggableListener listener) {
        this(null, options, listener);
    }

    protected DraggableBehavior(String selector, IDraggableListener listener) {
        this(selector, new Options(), listener);
    }

    protected DraggableBehavior(String selector, Options options, IDraggableListener listener) {
        super(selector, METHOD, options);
        this.listener = (IDraggableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.component != null) {
            throw new WicketRuntimeException("Behavior is already bound to another component.");
        }
        this.component = component;
        if (this.selector == null) {
            this.selector = IJQueryWidget.JQueryWidget.getSelector((Component)this.component);
        }
        this.onDragStartAjaxBehavior = this.newOnDragStartAjaxBehavior(this);
        this.component.add(new Behavior[]{this.onDragStartAjaxBehavior});
        this.onDragStopAjaxBehavior = this.newOnDragStopAjaxBehavior(this);
        this.component.add(new Behavior[]{this.onDragStopAjaxBehavior});
        if (this.listener.isCancelEventEnabled()) {
            this.onDragCancelAjaxBehavior = this.newOnDragCancelAjaxBehavior(this);
            this.component.add(new Behavior[]{this.onDragCancelAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        if (this.getOption("hint") == null) {
            this.setOption("hint", FCN_HINT);
        }
        this.setOption("dragstart", this.onDragStartAjaxBehavior.getCallbackFunction());
        this.setOption("dragend", this.onDragStopAjaxBehavior.getCallbackFunction());
        if (this.onDragCancelAjaxBehavior != null) {
            this.setOption("dragcancel", this.onDragCancelAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DraggableEvent) {
            DraggableEvent e = (DraggableEvent)event;
            if (e instanceof DragStartEvent) {
                Visits.visit((Iterable)target.getPage(), this.newDroppableBehaviorVisitor());
                this.listener.onDragStart(target, e.getTop(), e.getLeft());
            } else if (e instanceof DragStopEvent) {
                this.listener.onDragStop(target, e.getTop(), e.getLeft());
            } else if (e instanceof DragCancelEvent) {
                this.listener.onDragCancel(target, e.getTop(), e.getLeft());
            }
        }
    }

    private IVisitor<Component, ?> newDroppableBehaviorVisitor() {
        return (c, v) -> {
            for (DroppableBehavior behavior : c.getBehaviors(DroppableBehavior.class)) {
                behavior.setDraggable(this.component);
            }
        };
    }

    protected JQueryAjaxBehavior newOnDragStartAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDragStartAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnDragStopAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDragStopAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnDragCancelAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDragCancelAjaxBehavior(source);
    }

    protected static class DragCancelEvent
    extends DraggableEvent {
        protected DragCancelEvent() {
        }
    }

    protected static class DragStopEvent
    extends DraggableEvent {
        protected DragStopEvent() {
        }
    }

    protected static class DragStartEvent
    extends DraggableEvent {
        protected DragStartEvent() {
        }
    }

    protected static class DraggableEvent
    extends JQueryEvent {
        private final int top = RequestCycleUtils.getQueryParameterValue((String)"top").toInt(-1);
        private final int left = RequestCycleUtils.getQueryParameterValue((String)"left").toInt(-1);

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }
    }

    protected static class OnDragCancelAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDragCancelAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"top", (String)"e.sender.hintOffset.top | 0"), CallbackParameter.resolved((String)"left", (String)"e.sender.hintOffset.left | 0")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String statement = "this.element.removeClass('kendoDraggable-hide');";
            return statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragCancelEvent();
        }
    }

    protected static class OnDragStopAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDragStopAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"top", (String)"e.sender.hintOffset.top | 0"), CallbackParameter.resolved((String)"left", (String)"e.sender.hintOffset.left | 0")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String statement = "this.element.removeClass('kendoDraggable-hide');";
            return statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragStopEvent();
        }
    }

    protected static class OnDragStartAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDragStartAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"top", (String)"e.sender.hintOffset.top | 0"), CallbackParameter.resolved((String)"left", (String)"e.sender.hintOffset.left | 0")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String statement = "this.element.addClass('kendoDraggable-hide');";
            return statement + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new DragStartEvent();
        }
    }
}

