/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.ognl;

import java.util.Set;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.conversion.impl.XWorkConverter;
import org.apache.struts2.inject.Container;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.ognl.OgnlNullHandlerWrapper;
import org.apache.struts2.ognl.OgnlValueStack;
import org.apache.struts2.ognl.SecurityMemberAccess;
import org.apache.struts2.ognl.accessor.RootAccessor;
import org.apache.struts2.text.TextProvider;
import org.apache.struts2.util.CompoundRoot;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.util.ValueStackFactory;

public class OgnlValueStackFactory
implements ValueStackFactory {
    private static final Logger LOG = LogManager.getLogger(OgnlValueStackFactory.class);
    protected XWorkConverter xworkConverter;
    protected RootAccessor compoundRootAccessor;
    protected TextProvider textProvider;
    protected Container container;

    @Inject
    protected void setXWorkConverter(XWorkConverter converter) {
        this.xworkConverter = converter;
    }

    @Inject
    protected void setCompoundRootAccessor(RootAccessor compoundRootAccessor) {
        this.compoundRootAccessor = compoundRootAccessor;
        OgnlRuntime.setPropertyAccessor(CompoundRoot.class, (PropertyAccessor)compoundRootAccessor);
        OgnlRuntime.setMethodAccessor(CompoundRoot.class, (MethodAccessor)compoundRootAccessor);
    }

    @Inject
    protected void setMethodAccessor(MethodAccessor methodAccessor) {
        OgnlRuntime.setMethodAccessor(Object.class, (MethodAccessor)methodAccessor);
    }

    @Inject(value="system")
    protected void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Override
    public ValueStack createValueStack() {
        return this.createValueStack(null, true);
    }

    @Override
    public ValueStack createValueStack(ValueStack stack) {
        return this.createValueStack(stack, false);
    }

    protected ValueStack createValueStack(ValueStack stack, boolean useTextProvider) {
        OgnlValueStack newStack = new OgnlValueStack(stack, this.xworkConverter, this.compoundRootAccessor, useTextProvider ? this.textProvider : null, this.container.getInstance(SecurityMemberAccess.class));
        this.container.inject(newStack);
        return newStack.getActionContext().withContainer(this.container).withValueStack(newStack).getValueStack();
    }

    @Inject
    protected void setContainer(Container container) throws ClassNotFoundException {
        this.container = container;
        this.registerPropertyAccessors();
        this.registerNullHandlers();
        this.registerAdditionalMethodAccessors();
    }

    protected void registerAdditionalMethodAccessors() {
        Set<String> names = this.container.getInstanceNames(MethodAccessor.class);
        for (String name : names) {
            Class<?> cls;
            try {
                cls = Class.forName(name);
                if (cls.equals(Object.class)) continue;
                if (cls.equals(CompoundRoot.class)) {
                }
            }
            catch (ClassNotFoundException e) {}
            continue;
            MethodAccessor methodAccessor = this.container.getInstance(MethodAccessor.class, name);
            OgnlRuntime.setMethodAccessor(cls, (MethodAccessor)methodAccessor);
            LOG.debug("Registered custom OGNL MethodAccessor [{}] for class [{}]", (Object)methodAccessor.getClass().getName(), (Object)cls.getName());
        }
    }

    protected void registerNullHandlers() throws ClassNotFoundException {
        Set<String> names = this.container.getInstanceNames(org.apache.struts2.conversion.NullHandler.class);
        for (String name : names) {
            Class<?> cls = Class.forName(name);
            org.apache.struts2.conversion.NullHandler nullHandler = this.container.getInstance(org.apache.struts2.conversion.NullHandler.class, name);
            OgnlRuntime.setNullHandler(cls, (NullHandler)new OgnlNullHandlerWrapper(nullHandler));
            LOG.debug("Registered custom OGNL NullHandler [{}] for class [{}]", (Object)nullHandler.getClass().getName(), (Object)cls.getName());
        }
    }

    protected void registerPropertyAccessors() throws ClassNotFoundException {
        Set<String> names = this.container.getInstanceNames(PropertyAccessor.class);
        for (String name : names) {
            Class<?> cls = Class.forName(name);
            if (cls.equals(CompoundRoot.class)) continue;
            PropertyAccessor propertyAccessor = this.container.getInstance(PropertyAccessor.class, name);
            OgnlRuntime.setPropertyAccessor(cls, (PropertyAccessor)propertyAccessor);
            LOG.debug("Registered custom OGNL PropertyAccessor [{}] for class [{}]", (Object)propertyAccessor.getClass().getName(), (Object)cls.getName());
        }
    }
}

