/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class AwtFontAttribute {
    private final String family;
    private final FontInfo fontInfo;

    public static AwtFontAttribute fromAttributes(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        String family = (String)attributes.get(TextAttribute.FAMILY);
        FontInfo fontInfo = (FontInfo)attributes.get(JRTextAttribute.FONT_INFO);
        return new AwtFontAttribute(family, fontInfo);
    }

    public AwtFontAttribute(String family, FontInfo fontInfo) {
        this.family = family;
        this.fontInfo = fontInfo;
    }

    public boolean hasAttribute() {
        return this.family != null || this.fontInfo != null;
    }

    public String getFamily() {
        return this.family;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void putAttributes(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        attributes.put(TextAttribute.FAMILY, this.family);
        if (this.fontInfo != null) {
            attributes.put(JRTextAttribute.FONT_INFO, this.fontInfo);
        }
    }

    public int hashCode() {
        int hash = 43;
        hash = hash * 29 + this.family.hashCode();
        if (this.fontInfo != null) {
            hash = hash * 29 + this.fontInfo.getStyle();
            if (this.fontInfo.getFontFace() != null && this.fontInfo.getFontFace().getFont() != null) {
                hash = hash * 29 + this.fontInfo.getFontFace().getFont().hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        Font otherFont;
        if (!(obj instanceof AwtFontAttribute)) {
            return false;
        }
        AwtFontAttribute other = (AwtFontAttribute)obj;
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (this.fontInfo == null) {
            return other.fontInfo == null;
        }
        if (other.fontInfo == null) {
            return false;
        }
        if (this.fontInfo.getStyle() != other.fontInfo.getStyle()) {
            return false;
        }
        Font font = this.fontInfo.getFontFace() == null ? null : this.fontInfo.getFontFace().getFont();
        Font font2 = otherFont = other.fontInfo.getFontFace() == null ? null : other.fontInfo.getFontFace().getFont();
        return font == null ? otherFont == null : otherFont != null && font.equals(otherFont);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("{family: ");
        string.append(this.family);
        if (this.fontInfo != null) {
            string.append(", style: ");
            string.append(this.fontInfo.getStyle());
            if (this.fontInfo.getFontFace() != null && this.fontInfo.getFontFace().getFont() != null) {
                string.append(", font: ");
                string.append(this.fontInfo.getFontFace().getFont());
            }
        }
        string.append("}");
        return string.toString();
    }
}

