/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;

public final class JRIncrementerFactoryCache {
    private static Map<Class<?>, JRIncrementerFactory> factoriesMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);

    public static synchronized JRIncrementerFactory getInstance(Class<?> factoryClass) {
        JRIncrementerFactory incrementerFactory = factoriesMap.get(factoryClass);
        if (incrementerFactory == null) {
            try {
                incrementerFactory = (JRIncrementerFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(e);
            }
            factoriesMap.put(factoryClass, incrementerFactory);
        }
        return incrementerFactory;
    }

    private JRIncrementerFactoryCache() {
    }
}

