/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.base;

import com.google.gxp.com.google.common.base.FinalizableReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FinalizableReferenceQueue
extends ReferenceQueue<Object> {
    private static final Logger logger = Logger.getLogger(FinalizableReferenceQueue.class.getName());

    public static ReferenceQueue<Object> getInstance() {
        return LazyInstanceHolder.queue;
    }

    private FinalizableReferenceQueue() {
        this.start();
    }

    void start() {
        Thread thread = new Thread(this.getClass().getSimpleName()){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            FinalizableReferenceQueue.this.cleanUp(FinalizableReferenceQueue.this.remove());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    void cleanUp(Reference<?> reference) {
        try {
            ((FinalizableReference)((Object)reference)).finalizeReferent();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error cleaning up after reference.", t);
        }
    }

    private static class LazyInstanceHolder {
        static final ReferenceQueue<Object> queue = new FinalizableReferenceQueue();

        private LazyInstanceHolder() {
        }
    }
}

