/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.hadoop.hbase.io.crypto.tls.FileKeyStoreLoader;
import org.apache.hadoop.hbase.io.crypto.tls.PemReader;

final class PEMFileLoader
extends FileKeyStoreLoader {
    private PEMFileLoader(String keyStorePath, String trustStorePath, char[] keyStorePassword, char[] trustStorePassword) {
        super(keyStorePath, trustStorePath, keyStorePassword, trustStorePassword);
    }

    @Override
    public KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        File file = new File(this.keyStorePath);
        return PemReader.loadKeyStore(file, file, this.keyStorePassword);
    }

    @Override
    public KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        return PemReader.loadTrustStore(new File(this.trustStorePath));
    }

    static class Builder
    extends FileKeyStoreLoader.Builder<PEMFileLoader> {
        Builder() {
        }

        @Override
        PEMFileLoader build() {
            return new PEMFileLoader(this.keyStorePath, this.trustStorePath, this.keyStorePassword, this.trustStorePassword);
        }
    }
}

