/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.Graphs;
import org.apache.storm.shade.org.jgrapht.alg.RankingPathElement;
import org.apache.storm.shade.org.jgrapht.alg.RankingPathElementList;

class KShortestPathsIterator<V, E>
implements Iterator<Set<V>> {
    private V endVertex;
    private Graph<V, E> graph;
    private int k;
    private Set<V> prevImprovedVertices;
    private Map<V, RankingPathElementList<V, E>> prevSeenDataContainer;
    private Map<V, RankingPathElementList<V, E>> seenDataContainer;
    private V startVertex;
    private boolean startVertexEncountered;
    private int passNumber = 1;

    public KShortestPathsIterator(Graph<V, E> graph, V startVertex, V endVertex, int maxSize) {
        this.assertKShortestPathsIterator(graph, startVertex);
        this.graph = graph;
        this.startVertex = startVertex;
        this.endVertex = endVertex;
        this.k = maxSize;
        this.seenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevSeenDataContainer = new HashMap<V, RankingPathElementList<V, E>>();
        this.prevImprovedVertices = new HashSet<V>();
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public Set<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            HashSet improvedVertices = new HashSet();
            for (V vertex : this.prevImprovedVertices) {
                if (vertex.equals(this.endVertex)) continue;
                this.updateOutgoingVertices(vertex, improvedVertices);
            }
            this.savePassData(improvedVertices);
            ++this.passNumber;
            return improvedVertices;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    RankingPathElementList<V, E> getPathElements(V endVertex) {
        return this.seenDataContainer.get(endVertex);
    }

    private void assertKShortestPathsIterator(Graph<V, E> graph, V startVertex) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (startVertex == null) {
            throw new NullPointerException("startVertex is null");
        }
    }

    private RankingPathElementList<V, E> createSeenData(V vertex, E edge) {
        V oppositeVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
        RankingPathElementList<V, E> oppositeData = this.prevSeenDataContainer.get(oppositeVertex);
        RankingPathElementList<V, E> data = new RankingPathElementList<V, E>(this.graph, this.k, oppositeData, edge, this.endVertex);
        return data;
    }

    private Iterator<E> edgesOfIterator(V vertex) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(vertex).iterator();
        }
        return this.graph.edgesOf(vertex).iterator();
    }

    private void encounterStartVertex() {
        RankingPathElementList data = new RankingPathElementList(this.graph, this.k, new RankingPathElement(this.startVertex));
        this.seenDataContainer.put(this.startVertex, data);
        this.prevSeenDataContainer.put(this.startVertex, data);
        this.prevImprovedVertices.add(this.startVertex);
        this.startVertexEncountered = true;
    }

    private void savePassData(Set<V> improvedVertices) {
        for (V vertex : improvedVertices) {
            RankingPathElementList<V, E> pathElementList = this.seenDataContainer.get(vertex);
            RankingPathElementList<V, E> improvedPaths = new RankingPathElementList<V, E>(this.graph, pathElementList.maxSize, vertex);
            for (RankingPathElement rankingPathElement : pathElementList) {
                if (rankingPathElement.getHopCount() != this.passNumber) continue;
                improvedPaths.pathElements.add(rankingPathElement);
            }
            this.prevSeenDataContainer.put((RankingPathElementList<V, E>)vertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)improvedPaths);
        }
        this.prevImprovedVertices = improvedVertices;
    }

    private boolean tryToAddFirstPaths(V vertex, E edge) {
        RankingPathElementList<V, E> data = this.createSeenData(vertex, edge);
        if (!data.isEmpty()) {
            this.seenDataContainer.put((RankingPathElementList<V, E>)vertex, (RankingPathElementList<RankingPathElementList<V, E>, E>)data);
            return true;
        }
        return false;
    }

    private boolean tryToAddNewPaths(V vertex, E edge) {
        RankingPathElementList<V, E> data = this.seenDataContainer.get(vertex);
        V oppositeVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
        RankingPathElementList<V, E> oppositeData = this.prevSeenDataContainer.get(oppositeVertex);
        return data.addPathElements(oppositeData, edge);
    }

    private void updateOutgoingVertices(V vertex, Set<V> improvedVertices) {
        Iterator<E> iter2 = this.edgesOfIterator(vertex);
        while (iter2.hasNext()) {
            boolean relaxed;
            E edge = iter2.next();
            V vertexReachedByEdge = Graphs.getOppositeVertex(this.graph, edge, vertex);
            if (vertexReachedByEdge.equals(this.startVertex)) continue;
            if (this.seenDataContainer.containsKey(vertexReachedByEdge)) {
                relaxed = this.tryToAddNewPaths(vertexReachedByEdge, edge);
                if (!relaxed) continue;
                improvedVertices.add(vertexReachedByEdge);
                continue;
            }
            relaxed = this.tryToAddFirstPaths(vertexReachedByEdge, edge);
            if (!relaxed) continue;
            improvedVertices.add(vertexReachedByEdge);
        }
    }
}

