/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.TupleReceiver;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class ProjectedProcessor
implements TridentProcessor {
    Fields projectFields;
    TridentTupleView.ProjectionFactory factory;
    TridentContext context;

    public ProjectedProcessor(Fields projectFields) {
        this.projectFields = projectFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        if (tridentContext.getParentTupleFactories().size() != 1) {
            throw new RuntimeException("Projection processor can only have one parent");
        }
        this.context = tridentContext;
        this.factory = new TridentTupleView.ProjectionFactory(tridentContext.getParentTupleFactories().get(0), this.projectFields);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        TridentTuple toEmit = this.factory.create(tuple);
        for (TupleReceiver r : this.context.getReceivers()) {
            r.execute(processorContext, this.context.getOutStreamId(), toEmit);
        }
    }

    @Override
    public void flush() {
        for (TupleReceiver r : this.context.getReceivers()) {
            r.flush();
        }
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.factory;
    }
}

