/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.builtin;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.Assembly;
import org.apache.storm.trident.operation.BaseAggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;

public class FirstN
implements Assembly {
    Aggregator agg;

    public FirstN(int n, String sortField) {
        this(n, sortField, false);
    }

    public FirstN(int n, String sortField, boolean reverse) {
        this.agg = sortField != null ? new FirstNSortedAgg(n, sortField, reverse) : new FirstNAgg(n);
    }

    @Override
    public Stream apply(Stream input) {
        Fields outputFields = input.getOutputFields();
        return input.partitionAggregate(outputFields, this.agg, outputFields).global().partitionAggregate(outputFields, this.agg, outputFields);
    }

    public static class FirstNSortedAgg
    extends BaseAggregator<PriorityQueue> {
        int number;
        String sortField;
        boolean reverse;

        public FirstNSortedAgg(int n, String sortField, boolean reverse) {
            this.number = n;
            this.sortField = sortField;
            this.reverse = reverse;
        }

        @Override
        public PriorityQueue init(Object batchId, TridentCollector collector) {
            return new PriorityQueue<TridentTuple>(this.number, new Comparator<TridentTuple>(){

                @Override
                public int compare(TridentTuple t1, TridentTuple t2) {
                    Comparable c1 = (Comparable)t1.getValueByField(sortField);
                    Comparable c2 = (Comparable)t2.getValueByField(sortField);
                    int ret = c1.compareTo(c2);
                    if (reverse) {
                        ret *= -1;
                    }
                    return ret;
                }
            });
        }

        @Override
        public void aggregate(PriorityQueue state, TridentTuple tuple, TridentCollector collector) {
            state.add(tuple);
        }

        @Override
        public void complete(PriorityQueue val, TridentCollector collector) {
            int total = val.size();
            for (int i = 0; i < this.number && i < total; ++i) {
                TridentTuple t = (TridentTuple)val.remove();
                collector.emit(t);
            }
        }
    }

    public static class FirstNAgg
    extends BaseAggregator<State> {
        int number;

        public FirstNAgg(int n) {
            this.number = n;
        }

        @Override
        public State init(Object batchId, TridentCollector collector) {
            return new State();
        }

        @Override
        public void aggregate(State val, TridentTuple tuple, TridentCollector collector) {
            if (val.emitted < this.number) {
                collector.emit(tuple);
                ++val.emitted;
            }
        }

        @Override
        public void complete(State val, TridentCollector collector) {
        }

        static class State {
            int emitted = 0;

            State() {
            }
        }
    }
}

