/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.clojure;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.RT;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.clojure.ClojureUtil;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.spout.ISpout;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;

public class ClojureSpout
implements IRichSpout {
    Map<String, StreamInfo> fields;
    List<String> fnSpec;
    List<String> confSpec;
    List<Object> params;
    ISpout spout;

    public ClojureSpout(List fnSpec, List confSpec, List<Object> params, Map<String, StreamInfo> fields) {
        this.fnSpec = fnSpec;
        this.confSpec = confSpec;
        this.params = params;
        this.fields = fields;
    }

    public void open(final Map<String, Object> conf, final TopologyContext context, SpoutOutputCollector collector) {
        IFn hof = ClojureUtil.loadClojureFn(this.fnSpec.get(0), this.fnSpec.get(1));
        try {
            IFn preparer = (IFn)hof.applyTo(RT.seq(this.params));
            PersistentArrayMap collectorMap = new PersistentArrayMap(new Object[]{Keyword.intern((Symbol)Symbol.create((String)"output-collector")), collector, Keyword.intern((Symbol)Symbol.create((String)"context")), context});
            ArrayList<Object> args = new ArrayList<Object>((Map)collectorMap){
                final /* synthetic */ Map val$collectorMap;
                {
                    this.val$collectorMap = map2;
                    this.add(conf);
                    this.add(context);
                    this.add(this.val$collectorMap);
                }
            };
            this.spout = (ISpout)preparer.applyTo(RT.seq((Object)args));
            try {
                this.spout.open(conf, context, collector);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.spout.close();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void nextTuple() {
        try {
            this.spout.nextTuple();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void ack(Object msgId) {
        try {
            this.spout.ack(msgId);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void fail(Object msgId) {
        try {
            this.spout.fail(msgId);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (String stream : this.fields.keySet()) {
            StreamInfo info2 = this.fields.get(stream);
            declarer.declareStream(stream, info2.is_direct(), new Fields(info2.get_output_fields()));
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        IFn hof = ClojureUtil.loadClojureFn(this.confSpec.get(0), this.confSpec.get(1));
        try {
            return (Map)hof.applyTo(RT.seq(this.params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void activate() {
        try {
            this.spout.activate();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void deactivate() {
        try {
            this.spout.deactivate();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }
}

