/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import com.google.common.base.Joiner;
import java.util.Map;
import net.minidev.json.JSONValue;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.stats.StatsUtil;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeats {
    private static final Logger LOG = LoggerFactory.getLogger(Heartbeats.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("Command and path arguments must be provided.");
        }
        String command = args[0];
        String path = args[1];
        Map conf = Utils.readStormConfig();
        IStateStorage cluster = ClusterUtils.mkStateStorage((Map)conf, (Map)conf, (ClusterStateContext)new ClusterStateContext());
        LOG.info("Command: [{}]", (Object)command);
        switch (command) {
            case "list": {
                Heartbeats.handleListCommand(cluster, path);
                break;
            }
            case "get": {
                Heartbeats.handleGetCommand(cluster, path);
                break;
            }
            default: {
                LOG.info("Usage: heartbeats [list|get] path");
            }
        }
        try {
            cluster.close();
        }
        catch (Exception e) {
            LOG.info("Caught exception: {} on close.", (Object)e.getMessage(), (Object)e);
        }
        System.exit(0);
    }

    private static void handleListCommand(IStateStorage cluster, String path) {
        String message = Joiner.on((String)"\n").join((Iterable)cluster.get_worker_hb_children(path, false));
        LOG.info("list {}:\n{}\n", (Object)path, (Object)message);
    }

    private static void handleGetCommand(IStateStorage cluster, String path) {
        String message;
        byte[] hb = cluster.get_worker_hb(path, false);
        if (hb != null) {
            Map heartbeatMap = StatsUtil.convertZkWorkerHb((ClusterWorkerHeartbeat)((ClusterWorkerHeartbeat)Utils.deserialize((byte[])hb, ClusterWorkerHeartbeat.class)));
            message = JSONValue.toJSONString((Object)heartbeatMap);
        } else {
            message = "No Heartbeats found";
        }
        LOG.info(message);
    }
}

