/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.AppendCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class EachProcessor
implements TridentProcessor {
    Function function;
    TridentContext context;
    AppendCollector collector;
    Fields inputFields;
    TridentTupleView.ProjectionFactory projection;

    public EachProcessor(Fields inputFields, Function function) {
        this.function = function;
        this.inputFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Each operation can only have one parent");
        }
        this.context = tridentContext;
        this.collector = new AppendCollector(tridentContext);
        this.projection = new TridentTupleView.ProjectionFactory(parents.get(0), this.inputFields);
        this.function.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this.projection));
    }

    @Override
    public void flush() {
        this.collector.flush();
    }

    @Override
    public void cleanup() {
        this.function.cleanup();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        this.collector.setContext(processorContext, tuple);
        this.function.execute(this.projection.create(tuple), this.collector);
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.collector.getOutputFactory();
    }
}

