/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.GroupedMultiReducer;
import org.apache.storm.trident.operation.MultiReducer;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentMultiReducerContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class GroupedMultiReducerExecutor
implements MultiReducer<Map<TridentTuple, Object>> {
    GroupedMultiReducer reducer;
    List<Fields> groupFields;
    List<Fields> inputFields;
    List<TridentTupleView.ProjectionFactory> groupFactories = new ArrayList<TridentTupleView.ProjectionFactory>();
    List<TridentTupleView.ProjectionFactory> inputFactories = new ArrayList<TridentTupleView.ProjectionFactory>();

    public GroupedMultiReducerExecutor(GroupedMultiReducer reducer, List<Fields> groupFields, List<Fields> inputFields) {
        if (inputFields.size() != groupFields.size()) {
            throw new IllegalArgumentException("Multireducer groupFields and inputFields must be the same size");
        }
        this.groupFields = groupFields;
        this.inputFields = inputFields;
        this.reducer = reducer;
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentMultiReducerContext context) {
        for (int i = 0; i < this.groupFields.size(); ++i) {
            this.groupFactories.add(context.makeProjectionFactory(i, this.groupFields.get(i)));
            this.inputFactories.add(context.makeProjectionFactory(i, this.inputFields.get(i)));
        }
        this.reducer.prepare(conf, new TridentMultiReducerContext(this.inputFactories));
    }

    @Override
    public Map<TridentTuple, Object> init(TridentCollector collector) {
        return new HashMap<TridentTuple, Object>();
    }

    @Override
    public void execute(Map<TridentTuple, Object> state, int streamIndex, TridentTuple full, TridentCollector collector) {
        Object curr;
        TridentTupleView.ProjectionFactory groupFactory = this.groupFactories.get(streamIndex);
        TridentTupleView.ProjectionFactory inputFactory = this.inputFactories.get(streamIndex);
        TridentTuple group = groupFactory.create(full);
        TridentTuple input = inputFactory.create(full);
        if (!state.containsKey(group)) {
            curr = this.reducer.init(collector, group);
            state.put(group, curr);
        } else {
            curr = state.get(group);
        }
        this.reducer.execute(curr, streamIndex, group, input, collector);
    }

    @Override
    public void complete(Map<TridentTuple, Object> state, TridentCollector collector) {
        for (Map.Entry<TridentTuple, Object> e : state.entrySet()) {
            TridentTuple group = e.getKey();
            Object val = e.getValue();
            this.reducer.complete(val, group, collector);
        }
    }

    @Override
    public void cleanup() {
        this.reducer.cleanup();
    }
}

