/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.gzip;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

@Provider
@Priority(value=4000)
public class ConfiguredGZipEncoder
implements WriterInterceptor,
ClientRequestFilter {
    private boolean forceEncoding = false;

    public ConfiguredGZipEncoder(boolean forceEncoding) {
        this.forceEncoding = forceEncoding;
    }

    public void filter(ClientRequestContext context) throws IOException {
        if (context.hasEntity() && context.getHeaders().getFirst((Object)"Content-Encoding") == null && this.forceEncoding) {
            context.getHeaders().add((Object)"Content-Encoding", (Object)"gzip");
        }
    }

    public final void aroundWriteTo(WriterInterceptorContext context) throws IOException {
        String contentEncoding = (String)context.getHeaders().getFirst((Object)"Content-Encoding");
        if (contentEncoding != null && (contentEncoding.equals("gzip") || contentEncoding.equals("x-gzip"))) {
            context.setOutputStream((OutputStream)new GZIPOutputStream(context.getOutputStream()));
        }
        context.proceed();
    }
}

