/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore;

import java.util.Map;
import org.apache.storm.generated.WorkerMetrics;
import org.apache.storm.metricstore.MetricException;
import org.apache.storm.metricstore.WorkerMetricsProcessor;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.NimbusLeaderNotFoundException;

public class NimbusMetricProcessor
implements WorkerMetricsProcessor {
    @Override
    public void processWorkerMetrics(Map<String, Object> conf, WorkerMetrics metrics) throws MetricException {
        try (NimbusClient client = NimbusClient.Builder.withConf(conf).forDaemon().build();){
            client.getClient().processWorkerMetrics(metrics);
        }
        catch (TException | NimbusLeaderNotFoundException e) {
            throw new MetricException("Failed to process metrics", e);
        }
    }

    @Override
    public void prepare(Map<String, Object> config) throws MetricException {
    }
}

