/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.ReadClusterState;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.SupervisorAssignments;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizeAssignments
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizeAssignments.class);
    private Supervisor supervisor;
    private SupervisorAssignments assignments;
    private ReadClusterState readClusterState;

    public SynchronizeAssignments(Supervisor supervisor, SupervisorAssignments assignments, ReadClusterState readClusterState) {
        this.supervisor = supervisor;
        this.assignments = assignments;
        this.readClusterState = readClusterState;
    }

    private static void assignedAssignmentsToLocal(IStormClusterState clusterState, List<SupervisorAssignments> supervisorAssignments) {
        if (null == supervisorAssignments || supervisorAssignments.isEmpty()) {
            return;
        }
        HashMap<String, byte[]> serAssignments = new HashMap<String, byte[]>();
        for (SupervisorAssignments supervisorAssignment : supervisorAssignments) {
            if (supervisorAssignment == null) continue;
            for (Map.Entry entry : supervisorAssignment.get_storm_assignment().entrySet()) {
                serAssignments.put((String)entry.getKey(), Utils.serialize(entry.getValue()));
            }
        }
        clusterState.syncRemoteAssignments(serAssignments);
    }

    @Override
    public void run() {
        if (null == this.assignments) {
            this.getAssignmentsFromMaster(this.supervisor.getConf(), this.supervisor.getStormClusterState(), this.supervisor.getAssignmentId());
        } else {
            SynchronizeAssignments.assignedAssignmentsToLocal(this.supervisor.getStormClusterState(), Collections.singletonList(this.assignments));
        }
        this.readClusterState.run();
    }

    public List<SupervisorAssignments> getAllAssignmentsFromNumaSupervisors(Nimbus.Iface nimbus, String node) throws TException {
        ArrayList<SupervisorAssignments> supervisorAssignmentsList = new ArrayList<SupervisorAssignments>();
        Map<String, Object> validatedNumaMap = SupervisorUtils.getNumaMap(this.supervisor.getConf());
        for (Map.Entry<String, Object> numaEntry : validatedNumaMap.entrySet()) {
            String numaId = numaEntry.getKey();
            SupervisorAssignments assignments = nimbus.getSupervisorAssignments(node + "-numa-" + numaId);
            supervisorAssignmentsList.add(assignments);
        }
        SupervisorAssignments assignments = nimbus.getSupervisorAssignments(node);
        supervisorAssignmentsList.add(assignments);
        return supervisorAssignmentsList;
    }

    public void getAssignmentsFromMaster(Map conf, IStormClusterState clusterState, String node) {
        if (ConfigUtils.isLocalMode((Map)conf)) {
            try {
                List<SupervisorAssignments> supervisorAssignmentsList = this.getAllAssignmentsFromNumaSupervisors(this.supervisor.getLocalNimbus(), node);
                SynchronizeAssignments.assignedAssignmentsToLocal(clusterState, supervisorAssignmentsList);
            }
            catch (TException e) {
                LOG.error("Get assignments from local master exception", (Throwable)e);
            }
        } else {
            try (NimbusClient master = NimbusClient.Builder.withConf((Map)conf).forDaemon().build();){
                List<SupervisorAssignments> supervisorAssignmentsList = this.getAllAssignmentsFromNumaSupervisors(master.getClient(), node);
                LOG.debug("Sync an assignments from master, will start to sync with assignments: {}", supervisorAssignmentsList);
                SynchronizeAssignments.assignedAssignmentsToLocal(clusterState, supervisorAssignmentsList);
            }
            catch (Exception t) {
                LOG.error("Get assignments from master exception", (Throwable)t);
            }
        }
    }
}

