/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Index;

public class ContextRoutingHandler
extends Handler.AbstractContainer {
    private final Index<Handler> handlers;

    public ContextRoutingHandler(Map<String, ? extends Handler> handlers) {
        Index.Builder builder = new Index.Builder().caseSensitive(false);
        for (Map.Entry<String, ? extends Handler> entry : handlers.entrySet()) {
            builder.with(entry.getKey(), (Object)entry.getValue());
            this.addBean(entry.getValue());
        }
        this.handlers = builder.build();
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler handler = (Handler)this.handlers.getBest(request.getHttpURI().getPath());
        if (handler != null) {
            return handler.handle(request, response, callback);
        }
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (String key : this.handlers.keySet()) {
            ((Handler)this.handlers.get(key)).start();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (String key : this.handlers.keySet()) {
            ((Handler)this.handlers.get(key)).stop();
        }
    }

    public List<Handler> getHandlers() {
        return this.handlers.keySet().stream().map(arg_0 -> this.handlers.get(arg_0)).toList();
    }
}

