/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.util.ZooKeeperHiveHelper;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class HiveServer2
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(HiveServer2.class);
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;
    private String znodePath;
    private CuratorFramework zooKeeperClient;
    private boolean registeredWithZooKeeper = false;
    private final ACLProvider zooKeeperAclProvider = new ACLProvider(){
        List<ACL> nodeAcls = new ArrayList<ACL>();

        public List<ACL> getDefaultAcl() {
            if (ShimLoader.getHadoopShims().isSecurityEnabled()) {
                this.nodeAcls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
                this.nodeAcls.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
            } else {
                this.nodeAcls.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
            }
            return this.nodeAcls;
        }

        public List<ACL> getAclForPath(String path) {
            return this.getDefaultAcl();
        }
    };

    public HiveServer2() {
        super(HiveServer2.class.getSimpleName());
        HiveConf.setLoadHiveServer2Config((boolean)true);
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService(this);
        this.addService(this.cliService);
        this.thriftCLIService = HiveServer2.isHTTPTransportMode(hiveConf) ? new ThriftHttpCLIService(this.cliService) : new ThriftBinaryCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
        final HiveServer2 hiveServer2 = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                hiveServer2.stop();
            }
        });
    }

    public static boolean isHTTPTransportMode(HiveConf hiveConf) {
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    private void addServerInstanceToZooKeeper(HiveConf hiveConf) throws Exception {
        byte[] znodeDataUTF8;
        String instanceURI;
        String rootNamespace;
        block5: {
            String zooKeeperEnsemble = ZooKeeperHiveHelper.getQuorumServers((HiveConf)hiveConf);
            rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_NAMESPACE);
            instanceURI = this.getServerInstanceURI(hiveConf);
            znodeDataUTF8 = instanceURI.getBytes(Charset.forName("UTF-8"));
            this.setUpZooKeeperAuth(hiveConf);
            this.zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).aclProvider(this.zooKeeperAclProvider).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();
            this.zooKeeperClient.start();
            try {
                ((ACLBackgroundPathAndBytesable)this.zooKeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/" + rootNamespace);
                LOG.info((Object)("Created the root name space: " + rootNamespace + " on ZooKeeper for HiveServer2"));
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block5;
                LOG.fatal((Object)("Unable to create HiveServer2 namespace: " + rootNamespace + " on ZooKeeper"), (Throwable)e);
                throw e;
            }
        }
        try {
            String pathPrefix = "/" + rootNamespace + "/" + "serverUri=" + instanceURI + ";" + "version=" + HiveVersionInfo.getVersion() + ";" + "sequence=";
            this.znodePath = (String)((ACLBackgroundPathAndBytesable)this.zooKeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(pathPrefix, znodeDataUTF8);
            this.setRegisteredWithZooKeeper(true);
            if (((BackgroundPathable)this.zooKeeperClient.checkExists().usingWatcher((Watcher)new DeRegisterWatcher())).forPath(this.znodePath) == null) {
                throw new Exception("Unable to create znode for this HiveServer2 instance on ZooKeeper.");
            }
            LOG.info((Object)("Created a znode on ZooKeeper for HiveServer2 uri: " + instanceURI));
        }
        catch (KeeperException e) {
            LOG.fatal((Object)"Unable to create a znode for this server instance", (Throwable)e);
            throw e;
        }
    }

    private void setUpZooKeeperAuth(HiveConf hiveConf) throws Exception {
        if (ShimLoader.getHadoopShims().isSecurityEnabled()) {
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
            if (principal.isEmpty()) {
                throw new IOException("HiveServer2 Kerberos principal is empty");
            }
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
            if (keyTabFile.isEmpty()) {
                throw new IOException("HiveServer2 Kerberos keytab is empty");
            }
            ShimLoader.getHadoopShims().setZookeeperClientKerberosJaasConfig(principal, keyTabFile);
        }
    }

    private void removeServerInstanceFromZooKeeper() throws Exception {
        this.setRegisteredWithZooKeeper(false);
        this.zooKeeperClient.close();
        LOG.info((Object)"Server instance removed from ZooKeeper.");
    }

    public boolean isRegisteredWithZooKeeper() {
        return this.registeredWithZooKeeper;
    }

    private void setRegisteredWithZooKeeper(boolean registeredWithZooKeeper) {
        this.registeredWithZooKeeper = registeredWithZooKeeper;
    }

    private String getServerInstanceURI(HiveConf hiveConf) throws Exception {
        if (this.thriftCLIService == null || this.thriftCLIService.getServerIPAddress() == null) {
            throw new Exception("Unable to get the server address; it hasn't been initialized yet.");
        }
        return this.thriftCLIService.getServerIPAddress().getHostName() + ":" + this.thriftCLIService.getPortNumber();
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        LOG.info((Object)"Shutting down HiveServer2");
        HiveConf hiveConf = this.getHiveConf();
        super.stop();
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY)) {
            try {
                this.removeServerInstanceFromZooKeeper();
            }
            catch (Exception e) {
                LOG.error((Object)"Error removing znode for this HiveServer2 instance from ZooKeeper.", (Throwable)e);
            }
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) {
            try {
                TezSessionPoolManager.getInstance().stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Tez session pool manager stop had an error during stop of HiveServer2. Shutting down HiveServer2 anyway.", (Throwable)e);
            }
        }
    }

    private static void startHiveServer2() throws Throwable {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            LOG.info((Object)"Starting HiveServer2");
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            HiveServer2 server = null;
            try {
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY)) {
                    server.addServerInstanceToZooKeeper(hiveConf);
                }
                if (!hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) break;
                TezSessionPoolManager sessionPool = TezSessionPoolManager.getInstance();
                sessionPool.setupPool(hiveConf);
                sessionPool.startPool();
            }
            catch (Throwable throwable) {
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn((Object)("Error starting HiveServer2 on attempt " + attempts + ", will retry in 60 seconds"), throwable);
                try {
                    if (server != null) {
                        server.stop();
                        server = null;
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)"Exception caught when calling stop of HiveServer2 before retrying start", (Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    static void deleteServerInstancesFromZooKeeper(String versionNumber) throws Exception {
        HiveConf hiveConf = new HiveConf();
        String zooKeeperEnsemble = ZooKeeperHiveHelper.getQuorumServers((HiveConf)hiveConf);
        String rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_NAMESPACE);
        CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();
        zooKeeperClient.start();
        List znodePaths = (List)zooKeeperClient.getChildren().forPath("/" + rootNamespace);
        for (String znodePath : znodePaths) {
            if (!znodePath.contains("version=" + versionNumber + ";")) continue;
            LOG.info((Object)("Removing the znode: " + znodePath + " from ZooKeeper"));
            zooKeeperClient.delete().forPath("/" + rootNamespace + "/" + znodePath);
        }
        zooKeeperClient.close();
    }

    public static void main(String[] args) {
        HiveConf.setLoadHiveServer2Config((boolean)true);
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            ServerOptionsProcessorResponse oprocResponse = oproc.parse(args);
            String initLog4jMessage = LogUtils.initHiveLog4j();
            LOG.debug((Object)initLog4jMessage);
            HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Log)LOG);
            LOG.debug((Object)oproc.getDebugMessage().toString());
            oprocResponse.getServerOptionsExecutor().execute();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.error((Object)("Error initializing log: " + e.getMessage()), (Throwable)e);
            System.exit(-1);
        }
    }

    static class DeregisterOptionExecutor
    implements ServerOptionsExecutor {
        private final String versionNumber;

        DeregisterOptionExecutor(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public void execute() {
            try {
                HiveServer2.deleteServerInstancesFromZooKeeper(this.versionNumber);
            }
            catch (Exception e) {
                LOG.fatal((Object)("Error deregistering HiveServer2 instances for version: " + this.versionNumber + " from ZooKeeper"), (Throwable)e);
                System.exit(-1);
            }
            System.exit(0);
        }
    }

    static class StartOptionExecutor
    implements ServerOptionsExecutor {
        StartOptionExecutor() {
        }

        @Override
        public void execute() {
            try {
                HiveServer2.startHiveServer2();
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Error starting HiveServer2", t);
                System.exit(-1);
            }
        }
    }

    static class HelpOptionExecutor
    implements ServerOptionsExecutor {
        private final Options options;
        private final String serverName;

        HelpOptionExecutor(String serverName, Options options) {
            this.options = options;
            this.serverName = serverName;
        }

        @Override
        public void execute() {
            new HelpFormatter().printHelp(this.serverName, this.options);
            System.exit(0);
        }
    }

    static interface ServerOptionsExecutor {
        public void execute();
    }

    static class ServerOptionsProcessorResponse {
        private final ServerOptionsExecutor serverOptionsExecutor;

        ServerOptionsProcessorResponse(ServerOptionsExecutor serverOptionsExecutor) {
            this.serverOptionsExecutor = serverOptionsExecutor;
        }

        ServerOptionsExecutor getServerOptionsExecutor() {
            return this.serverOptionsExecutor;
        }
    }

    static class ServerOptionsProcessor {
        private final Options options = new Options();
        private CommandLine commandLine;
        private final String serverName;
        private final StringBuilder debugMessage = new StringBuilder();

        ServerOptionsProcessor(String serverName) {
            this.serverName = serverName;
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs((int)2);
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.withLongOpt((String)"hiveconf");
            OptionBuilder.withDescription((String)"Use value for given property");
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.hasArgs((int)1);
            OptionBuilder.withArgName((String)"versionNumber");
            OptionBuilder.withLongOpt((String)"deregister");
            OptionBuilder.withDescription((String)"Deregister all instances of given version from dynamic service discovery");
            this.options.addOption(OptionBuilder.create());
            this.options.addOption(new Option("H", "help", false, "Print help information"));
        }

        ServerOptionsProcessorResponse parse(String[] argv) {
            try {
                this.commandLine = new GnuParser().parse(this.options, argv);
                Properties confProps = this.commandLine.getOptionProperties("hiveconf");
                for (String propKey : confProps.stringPropertyNames()) {
                    this.debugMessage.append("Setting " + propKey + "=" + confProps.getProperty(propKey) + ";\n");
                    System.setProperty(propKey, confProps.getProperty(propKey));
                }
                if (this.commandLine.hasOption('H')) {
                    return new ServerOptionsProcessorResponse(new HelpOptionExecutor(this.serverName, this.options));
                }
                if (this.commandLine.hasOption("deregister")) {
                    return new ServerOptionsProcessorResponse(new DeregisterOptionExecutor(this.commandLine.getOptionValue("deregister")));
                }
            }
            catch (ParseException e) {
                System.err.println("Error starting HiveServer2 with given arguments: ");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return new ServerOptionsProcessorResponse(new StartOptionExecutor());
        }

        StringBuilder getDebugMessage() {
            return this.debugMessage;
        }
    }

    private class DeRegisterWatcher
    implements Watcher {
        private DeRegisterWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted)) {
                HiveServer2.this.setRegisteredWithZooKeeper(false);
                if (HiveServer2.this.cliService.getSessionManager().getOpenSessionCount() == 0) {
                    LOG.warn((Object)"This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
                    HiveServer2.this.stop();
                }
                LOG.warn((Object)"This HiveServer2 instance is now de-registered from ZooKeeper. The server will be shut down after the last client sesssion completes.");
            }
        }
    }
}

