/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HeartBeatFailure;
import org.apache.hive.hcatalog.streaming.ImpersonationFailed;
import org.apache.hive.hcatalog.streaming.InvalidPartition;
import org.apache.hive.hcatalog.streaming.InvalidTable;
import org.apache.hive.hcatalog.streaming.InvalidTrasactionState;
import org.apache.hive.hcatalog.streaming.PartitionCreationFailed;
import org.apache.hive.hcatalog.streaming.QueryFailedException;
import org.apache.hive.hcatalog.streaming.RecordWriter;
import org.apache.hive.hcatalog.streaming.StreamingConnection;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.hive.hcatalog.streaming.TransactionBatchUnAvailable;
import org.apache.hive.hcatalog.streaming.TransactionError;
import org.apache.thrift.TException;

public class HiveEndPoint {
    public final String metaStoreUri;
    public final String database;
    public final String table;
    public final ArrayList<String> partitionVals;
    private static final Log LOG = LogFactory.getLog((String)HiveEndPoint.class.getName());

    public HiveEndPoint(String metaStoreUri, String database, String table, List<String> partitionVals) {
        this.metaStoreUri = metaStoreUri;
        if (database == null) {
            throw new IllegalArgumentException("Database cannot be null for HiveEndPoint");
        }
        this.database = database;
        this.table = table;
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null for HiveEndPoint");
        }
        this.partitionVals = partitionVals == null ? new ArrayList() : new ArrayList<String>(partitionVals);
    }

    public StreamingConnection newConnection(boolean createPartIfNotExists) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, null, null);
    }

    public StreamingConnection newConnection(boolean createPartIfNotExists, HiveConf conf) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, conf, null);
    }

    public StreamingConnection newConnection(final boolean createPartIfNotExists, final HiveConf conf, final UserGroupInformation authenticatedUser) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        if (authenticatedUser == null) {
            return this.newConnectionImpl(authenticatedUser, createPartIfNotExists, conf);
        }
        try {
            return (StreamingConnection)authenticatedUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<StreamingConnection>(){

                @Override
                public StreamingConnection run() throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed {
                    return HiveEndPoint.this.newConnectionImpl(authenticatedUser, createPartIfNotExists, conf);
                }
            });
        }
        catch (IOException e) {
            throw new ConnectionError("Failed to connect as : " + authenticatedUser.getShortUserName(), (Exception)e);
        }
    }

    private StreamingConnection newConnectionImpl(UserGroupInformation ugi, boolean createPartIfNotExists, HiveConf conf) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed {
        return new ConnectionImpl(this, ugi, conf, createPartIfNotExists);
    }

    private static UserGroupInformation getUserGroupInfo(String user) throws ImpersonationFailed {
        try {
            return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to get UserGroupInfo for user : " + user), (Throwable)e);
            throw new ImpersonationFailed(user, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveEndPoint endPoint = (HiveEndPoint)o;
        if (this.database != null ? !this.database.equals(endPoint.database) : endPoint.database != null) {
            return false;
        }
        if (this.metaStoreUri != null ? !this.metaStoreUri.equals(endPoint.metaStoreUri) : endPoint.metaStoreUri != null) {
            return false;
        }
        if (!this.partitionVals.equals(endPoint.partitionVals)) {
            return false;
        }
        return !(this.table != null ? !this.table.equals(endPoint.table) : endPoint.table != null);
    }

    public int hashCode() {
        int result = this.metaStoreUri != null ? this.metaStoreUri.hashCode() : 0;
        result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
        result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
        result = 31 * result + this.partitionVals.hashCode();
        return result;
    }

    public String toString() {
        return "{metaStoreUri='" + this.metaStoreUri + '\'' + ", database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", partitionVals=" + this.partitionVals + " }";
    }

    static HiveConf createHiveConf(Class<?> clazz, String metaStoreUri) {
        HiveConf conf = new HiveConf(clazz);
        if (metaStoreUri != null) {
            HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.METASTOREURIS, metaStoreUri);
        }
        HiveEndPoint.overrideConfSettings(conf);
        return conf;
    }

    private static void overrideConfSettings(HiveConf conf) {
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, true);
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
    }

    private static void setHiveConf(HiveConf conf, HiveConf.ConfVars var, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Overriding HiveConf setting : " + var + " = " + value));
        }
        conf.setVar(var, value);
    }

    private static void setHiveConf(HiveConf conf, HiveConf.ConfVars var, boolean value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Overriding HiveConf setting : " + var + " = " + value));
        }
        conf.setBoolVar(var, value);
    }

    private static class TransactionBatchImpl
    implements TransactionBatch {
        private final String username;
        private final UserGroupInformation ugi;
        private final HiveEndPoint endPt;
        private final IMetaStoreClient msClient;
        private final RecordWriter recordWriter;
        private final List<Long> txnIds;
        private int currentTxnIndex;
        private final String partNameForLock;
        private TransactionBatch.TxnState state;
        private LockRequest lockRequest = null;

        private TransactionBatchImpl(String user, UserGroupInformation ugi, HiveEndPoint endPt, int numTxns, IMetaStoreClient msClient, RecordWriter recordWriter) throws StreamingException, TransactionBatchUnAvailable, InterruptedException {
            try {
                if (endPt.partitionVals != null && !endPt.partitionVals.isEmpty()) {
                    Table tableObj = msClient.getTable(endPt.database, endPt.table);
                    List partKeys = tableObj.getPartitionKeys();
                    this.partNameForLock = Warehouse.makePartName((List)partKeys, endPt.partitionVals);
                } else {
                    this.partNameForLock = null;
                }
                this.username = user;
                this.ugi = ugi;
                this.endPt = endPt;
                this.msClient = msClient;
                this.recordWriter = recordWriter;
                this.txnIds = this.openTxnImpl(msClient, user, numTxns, ugi);
                this.currentTxnIndex = -1;
                this.state = TransactionBatch.TxnState.INACTIVE;
                recordWriter.newBatch(this.txnIds.get(0), this.txnIds.get(this.txnIds.size() - 1));
            }
            catch (TException e) {
                throw new TransactionBatchUnAvailable(endPt, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new TransactionBatchUnAvailable(endPt, (Exception)e);
            }
        }

        private List<Long> openTxnImpl(final IMetaStoreClient msClient, final String user, final int numTxns, UserGroupInformation ugi) throws IOException, TException, InterruptedException {
            if (ugi == null) {
                return msClient.openTxns(user, numTxns).getTxn_ids();
            }
            return (List)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return msClient.openTxns(user, numTxns).getTxn_ids();
                }
            });
        }

        public String toString() {
            if (this.txnIds == null || this.txnIds.isEmpty()) {
                return "{}";
            }
            return "TxnIds=[" + this.txnIds.get(0) + "..." + this.txnIds.get(this.txnIds.size() - 1) + "] on endPoint = " + this.endPt;
        }

        @Override
        public void beginNextTransaction() throws TransactionError, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                this.beginNextTransactionImpl();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws TransactionError {
                        TransactionBatchImpl.this.beginNextTransactionImpl();
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed switching to next Txn as user '" + this.username + "' in Txn batch :" + this, e);
            }
        }

        private void beginNextTransactionImpl() throws TransactionError {
            if (this.currentTxnIndex >= this.txnIds.size()) {
                throw new InvalidTrasactionState("No more transactions available in current batch for end point : " + this.endPt);
            }
            ++this.currentTxnIndex;
            this.lockRequest = TransactionBatchImpl.createLockRequest(this.endPt, this.partNameForLock, this.username, this.getCurrentTxnId());
            try {
                LockResponse res = this.msClient.lock(this.lockRequest);
                if (res.getState() != LockState.ACQUIRED) {
                    throw new TransactionError("Unable to acquire lock on " + this.endPt);
                }
            }
            catch (TException e) {
                throw new TransactionError("Unable to acquire lock on " + this.endPt, (Exception)((Object)e));
            }
            this.state = TransactionBatch.TxnState.OPEN;
        }

        @Override
        public Long getCurrentTxnId() {
            if (this.currentTxnIndex >= 0) {
                return this.txnIds.get(this.currentTxnIndex);
            }
            return -1L;
        }

        @Override
        public TransactionBatch.TxnState getCurrentTransactionState() {
            return this.state;
        }

        @Override
        public int remainingTransactions() {
            if (this.currentTxnIndex >= 0) {
                return this.txnIds.size() - this.currentTxnIndex - 1;
            }
            return this.txnIds.size();
        }

        @Override
        public void write(final byte[] record) throws StreamingException, InterruptedException, ImpersonationFailed {
            if (this.ugi == null) {
                this.recordWriter.write(this.getCurrentTxnId(), record);
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        TransactionBatchImpl.this.recordWriter.write(TransactionBatchImpl.this.getCurrentTxnId(), record);
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed wirting as user '" + this.username + "' to endPoint :" + this.endPt + ". Transaction Id: " + this.getCurrentTxnId(), e);
            }
        }

        @Override
        public void write(final Collection<byte[]> records) throws StreamingException, InterruptedException, ImpersonationFailed {
            if (this.ugi == null) {
                this.writeImpl(records);
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        TransactionBatchImpl.this.writeImpl(records);
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed writing as user '" + this.username + "' to endPoint :" + this.endPt + ". Transaction Id: " + this.getCurrentTxnId(), e);
            }
        }

        private void writeImpl(Collection<byte[]> records) throws StreamingException {
            for (byte[] record : records) {
                this.recordWriter.write(this.getCurrentTxnId(), record);
            }
        }

        @Override
        public void commit() throws TransactionError, StreamingException, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                this.commitImpl();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        TransactionBatchImpl.this.commitImpl();
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed committing Txn ID " + this.getCurrentTxnId() + " as user '" + this.username + "'on endPoint :" + this.endPt + ". Transaction Id: ", e);
            }
        }

        private void commitImpl() throws TransactionError, StreamingException {
            try {
                this.recordWriter.flush();
                this.msClient.commitTxn(this.txnIds.get(this.currentTxnIndex).longValue());
                this.state = TransactionBatch.TxnState.COMMITTED;
            }
            catch (NoSuchTxnException e) {
                throw new TransactionError("Invalid transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
            }
            catch (TxnAbortedException e) {
                throw new TransactionError("Aborted transaction cannot be committed", (Exception)((Object)e));
            }
            catch (TException e) {
                throw new TransactionError("Unable to commit transaction" + this.getCurrentTxnId(), (Exception)((Object)e));
            }
        }

        @Override
        public void abort() throws TransactionError, StreamingException, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                this.abortImpl();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        TransactionBatchImpl.this.abortImpl();
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed aborting Txn " + this.getCurrentTxnId() + " as user '" + this.username + "' on endPoint :" + this.endPt, e);
            }
        }

        private void abortImpl() throws TransactionError, StreamingException {
            try {
                this.recordWriter.clear();
                this.msClient.rollbackTxn(this.getCurrentTxnId().longValue());
                this.state = TransactionBatch.TxnState.ABORTED;
            }
            catch (NoSuchTxnException e) {
                throw new TransactionError("Unable to abort invalid transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
            }
            catch (TException e) {
                throw new TransactionError("Unable to abort transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
            }
        }

        @Override
        public void heartbeat() throws StreamingException, HeartBeatFailure {
            Long first = this.txnIds.get(this.currentTxnIndex);
            Long last = this.txnIds.get(this.txnIds.size() - 1);
            try {
                HeartbeatTxnRangeResponse resp = this.msClient.heartbeatTxnRange(first.longValue(), last.longValue());
                if (!resp.getAborted().isEmpty() || !resp.getNosuch().isEmpty()) {
                    throw new HeartBeatFailure(resp.getAborted(), resp.getNosuch());
                }
            }
            catch (TException e) {
                throw new StreamingException("Failure to heartbeat on ids (" + first + "src/gen/thrift" + last + ") on end point : " + this.endPt);
            }
        }

        @Override
        public void close() throws StreamingException, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                this.state = TransactionBatch.TxnState.INACTIVE;
                this.recordWriter.closeBatch();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        TransactionBatchImpl.this.state = TransactionBatch.TxnState.INACTIVE;
                        TransactionBatchImpl.this.recordWriter.closeBatch();
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed closing Txn Batch as user '" + this.username + "' on  endPoint :" + this.endPt, e);
            }
        }

        private static LockRequest createLockRequest(HiveEndPoint hiveEndPoint, String partNameForLock, String user, long txnId) {
            LockRequestBuilder rqstBuilder = new LockRequestBuilder();
            rqstBuilder.setUser(user);
            rqstBuilder.setTransactionId(txnId);
            LockComponentBuilder lockCompBuilder = new LockComponentBuilder().setDbName(hiveEndPoint.database).setTableName(hiveEndPoint.table).setShared();
            if (partNameForLock != null && !partNameForLock.isEmpty()) {
                lockCompBuilder.setPartitionName(partNameForLock);
            }
            rqstBuilder.addLockComponent(lockCompBuilder.build());
            return rqstBuilder.build();
        }
    }

    private static class ConnectionImpl
    implements StreamingConnection {
        private final IMetaStoreClient msClient;
        private final HiveEndPoint endPt;
        private final UserGroupInformation ugi;
        private final String username;
        private final boolean secureMode;

        private ConnectionImpl(HiveEndPoint endPoint, UserGroupInformation ugi, HiveConf conf, boolean createPart) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed {
            this.endPt = endPoint;
            this.ugi = ugi;
            String string = this.username = ugi == null ? System.getProperty("user.name") : ugi.getShortUserName();
            if (conf == null) {
                conf = HiveEndPoint.createHiveConf(this.getClass(), endPoint.metaStoreUri);
            } else {
                HiveEndPoint.overrideConfSettings(conf);
            }
            this.secureMode = ugi == null ? false : ugi.hasKerberosCredentials();
            this.msClient = ConnectionImpl.getMetaStoreClient(endPoint, conf, this.secureMode);
            if (createPart && !endPoint.partitionVals.isEmpty()) {
                ConnectionImpl.createPartitionIfNotExists(endPoint, this.msClient, conf);
            }
        }

        @Override
        public void close() {
            if (this.ugi == null) {
                this.msClient.close();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ConnectionImpl.this.msClient.close();
                        return null;
                    }
                });
            }
            catch (IOException e) {
                LOG.error((Object)("Error closing connection to " + this.endPt), (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Interrupted when closing connection to " + this.endPt), (Throwable)e);
            }
        }

        @Override
        public TransactionBatch fetchTransactionBatch(final int numTransactions, final RecordWriter recordWriter) throws StreamingException, TransactionBatchUnAvailable, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                return this.fetchTransactionBatchImpl(numTransactions, recordWriter);
            }
            try {
                return (TransactionBatch)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TransactionBatch>(){

                    @Override
                    public TransactionBatch run() throws StreamingException, InterruptedException {
                        return ConnectionImpl.this.fetchTransactionBatchImpl(numTransactions, recordWriter);
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed to fetch Txn Batch as user '" + this.ugi.getShortUserName() + "' when acquiring Transaction Batch on endPoint " + this.endPt, e);
            }
        }

        private TransactionBatch fetchTransactionBatchImpl(int numTransactions, RecordWriter recordWriter) throws StreamingException, TransactionBatchUnAvailable, InterruptedException {
            return new TransactionBatchImpl(this.username, this.ugi, this.endPt, numTransactions, this.msClient, recordWriter);
        }

        private static void createPartitionIfNotExists(HiveEndPoint ep, IMetaStoreClient msClient, HiveConf conf) throws InvalidTable, PartitionCreationFailed {
            if (ep.partitionVals.isEmpty()) {
                return;
            }
            SessionState localSession = null;
            if (SessionState.get() == null) {
                localSession = SessionState.start((SessionState)new CliSessionState(conf));
            }
            Driver driver = new Driver(conf);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempting to create partition (if not existent) " + ep));
                }
                List partKeys = msClient.getTable(ep.database, ep.table).getPartitionKeys();
                ConnectionImpl.runDDL(driver, "use " + ep.database);
                String query = "alter table " + ep.table + " add if not exists partition " + ConnectionImpl.partSpecStr(partKeys, ep.partitionVals);
                ConnectionImpl.runDDL(driver, query);
            }
            catch (MetaException e) {
                LOG.error((Object)("Failed to create partition : " + ep), (Throwable)e);
                throw new PartitionCreationFailed(ep, (Exception)((Object)e));
            }
            catch (NoSuchObjectException e) {
                LOG.error((Object)("Failed to create partition : " + ep), (Throwable)e);
                throw new InvalidTable(ep.database, ep.table);
            }
            catch (TException e) {
                LOG.error((Object)("Failed to create partition : " + ep), (Throwable)e);
                throw new PartitionCreationFailed(ep, (Exception)((Object)e));
            }
            catch (QueryFailedException e) {
                LOG.error((Object)("Failed to create partition : " + ep), (Throwable)e);
                throw new PartitionCreationFailed(ep, (Exception)e);
            }
            finally {
                driver.close();
                try {
                    if (localSession != null) {
                        localSession.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error closing SessionState used to run Hive DDL.");
                }
            }
        }

        private static boolean runDDL(Driver driver, String sql) throws QueryFailedException {
            int retryCount = 1;
            for (int attempt = 0; attempt <= retryCount; ++attempt) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Running Hive Query: " + sql));
                    }
                    driver.run(sql);
                    return true;
                }
                catch (CommandNeedRetryException e) {
                    if (attempt != retryCount) continue;
                    throw new QueryFailedException(sql, e);
                }
            }
            return false;
        }

        private static String partSpecStr(List<FieldSchema> partKeys, ArrayList<String> partVals) {
            if (partKeys.size() != partVals.size()) {
                throw new IllegalArgumentException("Partition values:" + partVals + ", does not match the partition Keys in table :" + partKeys);
            }
            StringBuffer buff = new StringBuffer(partKeys.size() * 20);
            buff.append(" ( ");
            int i = 0;
            for (FieldSchema schema : partKeys) {
                buff.append(schema.getName());
                buff.append("='");
                buff.append(partVals.get(i));
                buff.append("'");
                if (i != partKeys.size() - 1) {
                    buff.append(",");
                }
                ++i;
            }
            buff.append(" )");
            return buff.toString();
        }

        private static IMetaStoreClient getMetaStoreClient(HiveEndPoint endPoint, HiveConf conf, boolean secureMode) throws ConnectionError {
            if (endPoint.metaStoreUri != null) {
                conf.setVar(HiveConf.ConfVars.METASTOREURIS, endPoint.metaStoreUri);
            }
            if (secureMode) {
                conf.setBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, true);
            }
            try {
                return new HiveMetaStoreClient(conf);
            }
            catch (MetaException e) {
                throw new ConnectionError("Error connecting to Hive Metastore URI: " + endPoint.metaStoreUri, (Exception)((Object)e));
            }
        }
    }
}

