/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

@Mojo(name="embed-features", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class EmbedFeaturesMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig embed;
    @Parameter(defaultValue="META-INF/features")
    private String resourcesPath;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File buildOutputDirectory;

    private void include(File directory, Feature feature) throws MojoExecutionException {
        String classifier = feature.getId().getClassifier();
        File outputFile = new File(directory, (String)(classifier == null ? "feature.json" : "feature-" + classifier + ".json"));
        outputFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(outputFile);){
            FeatureJSONWriter.write((Writer)writer, (Feature)feature);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write feature " + feature.getId().toMvnId() + " to " + String.valueOf(outputFile), (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, Feature> features;
        this.checkPreconditions();
        Map<String, Feature> map = features = this.embed == null ? this.selectAllFeatureFilesAndAggregates() : this.getSelectedFeatures(this.embed);
        if (features.isEmpty()) {
            this.getLog().info((CharSequence)"No features to embed");
        } else {
            this.getLog().info((CharSequence)("Embedding " + features.size() + " features at " + this.resourcesPath));
            File directory = new File(this.buildOutputDirectory, this.resourcesPath.replace('/', File.separatorChar));
            for (Feature f : features.values()) {
                this.include(directory, f);
            }
        }
    }
}

