/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.webdav.lock;

import java.util.UUID;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.lock.AbstractActiveLock;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.lock.LockInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.lock.Scope;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.lock.Type;

public class DefaultActiveLock
extends AbstractActiveLock {
    private final String token = "opaquelocktoken:" + UUID.randomUUID();
    private String owner;
    private boolean isDeep = true;
    private long expirationTime = Integer.MAX_VALUE;

    public DefaultActiveLock() {
    }

    public DefaultActiveLock(LockInfo lockInfo) {
        if (lockInfo != null) {
            if (!Type.WRITE.equals(lockInfo.getType()) || !Scope.EXCLUSIVE.equals(lockInfo.getScope())) {
                throw new IllegalArgumentException("Only 'exclusive write' lock is allowed scope/type pair.");
            }
            this.owner = lockInfo.getOwner();
            this.isDeep = lockInfo.isDeep();
            this.setTimeout(lockInfo.getTimeout());
        }
    }

    @Override
    public boolean isLockedByToken(String lockToken) {
        return this.token != null && this.token.equals(lockToken);
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public long getTimeout() {
        return this.expirationTime - System.currentTimeMillis();
    }

    @Override
    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.expirationTime = System.currentTimeMillis() + timeout;
        }
    }

    @Override
    public boolean isDeep() {
        return this.isDeep;
    }

    @Override
    public void setIsDeep(boolean isDeep) {
        this.isDeep = isDeep;
    }

    @Override
    public Type getType() {
        return Type.WRITE;
    }

    @Override
    public Scope getScope() {
        return Scope.EXCLUSIVE;
    }
}

