/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.commons.xml;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.PathNotFoundException;
import relocated_for_contentpackage.javax.jcr.Property;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.javax.jcr.Value;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.xml.Exporter;
import relocated_for_contentpackage.org.apache.jackrabbit.util.ISO9075;
import relocated_for_contentpackage.org.apache.jackrabbit.value.ValueHelper;

public class DocumentViewExporter
extends Exporter {
    public DocumentViewExporter(Session session, ContentHandler handler, boolean recurse, boolean binary) {
        super(session, handler, recurse, binary);
    }

    @Override
    protected void exportNode(String uri, String local, Node node) throws RepositoryException, SAXException {
        if ("http://www.jcp.org/jcr/1.0".equals(uri) && "xmltext".equals(local)) {
            try {
                Property property = node.getProperty(this.helper.getJcrName("jcr:xmlcharacters"));
                char[] ch = property.getString().toCharArray();
                this.characters(ch, 0, ch.length);
            }
            catch (PathNotFoundException property) {}
        } else {
            this.exportProperties(node);
            String encoded = ISO9075.encode(local);
            this.startElement(uri, encoded);
            this.exportNodes(node);
            this.endElement(uri, encoded);
        }
    }

    @Override
    protected void exportProperty(String uri, String local, Value value) throws RepositoryException {
        String attribute = ValueHelper.serialize(value, false);
        this.addAttribute(uri, ISO9075.encode(local), attribute);
    }

    @Override
    protected void exportProperty(String uri, String local, int type, Value[] values) {
    }
}

