/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.apache.sling.jcr.contentloader.internal.BundleHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling JCR Content Loader Web Console Plugin", "felix.webconsole.label=jcr-content-loader", "felix.webconsole.title=JCR Content Loader", "felix.webconsole.category=Sling", "felix.webconsole.css=jcr-content-loader/res/ui/main.css"})
public class ContentLoaderWebConsolePlugin
extends GenericServlet {
    public static final String LABEL = "jcr-content-loader";
    protected static final String RES_LOC = "jcr-content-loader/res/ui/";
    @Reference
    SlingRepository repository;
    @Reference
    BundleHelper bundleHelper;
    BundleContext context;

    @Activate
    private void activate(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws IOException {
        Session session = null;
        PrintWriter pw = res.getWriter();
        try {
            session = this.repository.loginService(null, null);
            pw.print("<p class='statline ui-state-highlight'>Apache Sling JCR Content Loader");
            pw.print("</p>");
            pw.println("<table class='nicetable'><thead>");
            pw.println("<tr><th>Bundle</th><th>Path Entries</th><th>Content Loaded Successfully?</th><th>Uninstall Paths (format: JCR workspace:path)</th></tr>");
            pw.println("</thead><tbody>");
            int bundleNo = 1;
            for (Bundle bundle : this.context.getBundles()) {
                String contentHeader = (String)bundle.getHeaders().get("Sling-Initial-Content");
                if (contentHeader == null) continue;
                this.printBundleInfoTableRow(pw, req, session, bundle, bundleNo++ % 2 == 0);
            }
            pw.println("</tbody></table>");
        }
        catch (RepositoryException e) {
            pw.println("Error accessing the underlying repository");
            e.printStackTrace(pw);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    void printBundleInfoTableRow(PrintWriter pw, ServletRequest req, Session session, Bundle bundle, boolean isEven) throws RepositoryException {
        String loadedDetails;
        Map<String, Object> contentInfoMap = this.bundleHelper.getBundleContentInfo(session, bundle, false);
        this.bundleHelper.unlockBundleContentInfo(session, bundle, false, null);
        String[] uninstallPaths = (String[])contentInfoMap.get("uninstall-paths");
        String uninstallPathsString = uninstallPaths == null ? "-" : Arrays.stream(uninstallPaths).map(ResponseUtil::escapeXml).collect(Collectors.joining("<br/>"));
        Object loadedDate = contentInfoMap.get("content-load-time");
        if (!(loadedDate instanceof Calendar)) {
            loadedDetails = "?";
        } else {
            Calendar calendar = (Calendar)Calendar.class.cast(loadedDate);
            String formatterDate = DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(calendar.getTimeZone().toZoneId()).withLocale(req.getLocale()).format(calendar.toInstant());
            String loadedBy = String.valueOf(contentInfoMap.get("content-loaded-by"));
            loadedDetails = String.format("%s<br/>by Sling ID %s", formatterDate, ResponseUtil.escapeXml((String)loadedBy));
        }
        String bundleLink = req.getAttribute("felix.webconsole.appRoot") + "/bundles/" + bundle.getBundleId();
        String pathEntriesString = StreamSupport.stream(Spliterators.spliteratorUnknownSize(PathEntry.getContentPaths(bundle), 16), false).map(ContentLoaderWebConsolePlugin::printPathEntryTable).collect(Collectors.joining("\n"));
        String trClass = (isEven ? "even" : "odd") + " ui-state-default";
        pw.printf("<tr class='%s'><td><a href=\"%s\">%s (%d)</a></td><td>%s</td><td>%s<br/><br/>(%s)</td><td>%s</td></tr>", trClass, bundleLink, ResponseUtil.escapeXml((String)bundle.getSymbolicName()), bundle.getBundleId(), pathEntriesString, PropertiesUtil.toBoolean((Object)contentInfoMap.get("content-loaded"), (boolean)false), loadedDetails, uninstallPathsString);
    }

    static String printPathEntryTable(PathEntry entry) {
        StringBuilder sb = new StringBuilder();
        int row = 1;
        sb.append("<table class='nicetable nested'><thead>");
        sb.append("<tr><th>Path</th><th>").append(ResponseUtil.escapeXml((String)entry.getPath())).append("</th><tr>");
        sb.append("</thead><tbody>");
        ContentLoaderWebConsolePlugin.printPathEntryTableRow(sb, "Target Path", ResponseUtil.escapeXml((String)entry.getTarget()), row++);
        ContentLoaderWebConsolePlugin.printPathEntryTableRow(sb, "Overwrite", Boolean.toString(entry.isOverwrite()), row++);
        ContentLoaderWebConsolePlugin.printPathEntryTableRow(sb, "Uninstall", Boolean.toString(entry.isUninstall()), row++);
        ContentLoaderWebConsolePlugin.printPathEntryTableRow(sb, "Ignored Content Readers", ResponseUtil.escapeXml((String)String.join((CharSequence)", ", entry.getIgnoredContentReaders())), row);
        sb.append("</tbody></table>");
        return sb.toString();
    }

    static void printPathEntryTableRow(StringBuilder sb, String name, String value, int i) {
        String trClass = (i % 2 == 0 ? "even" : "odd") + " ui-state-default";
        sb.append("<tr class='").append(trClass).append("'><td>").append(name).append("</td><td>").append(value).append("</td></tr>");
    }

    private URL getResource(String path) {
        if (path.startsWith("/jcr-content-loader/res/ui/")) {
            int index = path.indexOf(47, 1);
            if (index <= 0) {
                throw new IllegalStateException("The relativeResourcePrefix must contain at least one '/'");
            }
            return ((Object)((Object)this)).getClass().getResource(path.substring(index));
        }
        return null;
    }
}

