/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.GridSliceSelector;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.util.resources.IndexedResourceBundle;

abstract class ViewAndControls {
    private static final Insets CAPTION_MARGIN = new Insets(12.0, 0.0, 6.0, 0.0);
    private static final Insets NEXT_CAPTION_MARGIN = new Insets(30.0, 0.0, 6.0, 0.0);
    static final Insets CONTENT_MARGIN = new Insets(0.0, 0.0, 0.0, Styles.FORM_INSETS.getLeft());
    private static final int SLICE_SELECTOR_INDEX = 3;
    Toggle selector;
    final VBox viewAndNavigation;
    TitledPane[] controlPanes;
    private Accordion controls;
    protected final GridSliceSelector sliceSelector;
    protected final StatusBar status;
    protected final CoverageExplorer owner;
    boolean isAdjustingSlice;

    protected ViewAndControls(CoverageExplorer owner) {
        this.owner = owner;
        this.status = new StatusBar(owner.referenceSystems);
        this.sliceSelector = new GridSliceSelector(owner.getLocale());
        this.viewAndNavigation = new VBox();
        this.sliceSelector.selectedExtentProperty().addListener((p, o, n) -> this.onSliceChanged((GridExtent)n));
    }

    final void setView(Region view) {
        Region bar = this.status.getView();
        Region nav = this.sliceSelector.getView();
        VBox.setVgrow((Node)view, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)bar, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)nav, (Priority)Priority.NEVER);
        Separator sep = new Separator();
        this.viewAndNavigation.getChildren().setAll((Object[])new Node[]{view, sep, bar});
        SplitPane.setResizableWithParent((Node)this.viewAndNavigation, (Boolean)Boolean.TRUE);
        this.sliceSelector.status = this.status;
    }

    final Accordion controls() {
        if (this.controls == null) {
            TitledPane[] panes = this.controlPanes;
            this.controls = new Accordion(panes);
            this.controls.setExpandedPane(panes[0]);
            SplitPane.setResizableWithParent((Node)this.controls, (Boolean)Boolean.FALSE);
        }
        return this.controls;
    }

    private void onSliceChanged(GridExtent slice) {
        GridCoverage coverage = this.owner.getCoverage();
        if (coverage != null) {
            try {
                this.isAdjustingSlice = true;
                this.load(new ImageRequest(this.owner.getResource(), coverage, slice));
            }
            finally {
                this.isAdjustingSlice = false;
            }
        }
    }

    abstract void load(ImageRequest var1);

    final GridExtent configureSliceSelector(GridGeometry geometry) {
        this.sliceSelector.gridGeometry.set((Object)geometry);
        ObservableList components = this.viewAndNavigation.getChildren();
        int count = components.size();
        if (this.sliceSelector.isEmpty()) {
            if (count > 3) {
                components.remove(3);
            }
        } else if (count <= 3) {
            components.add((Object)this.sliceSelector.getView());
        }
        return (GridExtent)this.sliceSelector.selectedExtentProperty().getValue();
    }

    static Label label(IndexedResourceBundle vocabulary, short key, Control control) {
        if (control == null) {
            return null;
        }
        control.setMaxWidth(Double.POSITIVE_INFINITY);
        Label label = new Label(vocabulary.getLabel(key));
        label.setLabelFor((Node)control);
        return label;
    }

    static Label labelOfGroup(IndexedResourceBundle vocabulary, short key, Region group, boolean isFirst) {
        Label label = new Label(vocabulary.getString(key));
        label.setPadding(isFirst ? CAPTION_MARGIN : NEXT_CAPTION_MARGIN);
        label.setLabelFor((Node)group);
        label.setFont(ViewAndControls.fontOfGroup());
        return label;
    }

    private static Font fontOfGroup() {
        return Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0);
    }
}

