/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRegisterStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskResultStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskRunningStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticRdbRepository {
    private static final Logger log = LoggerFactory.getLogger(StatisticRdbRepository.class);
    private static final String TABLE_TASK_RESULT_STATISTICS = "TASK_RESULT_STATISTICS";
    private static final String TABLE_TASK_RUNNING_STATISTICS = "TASK_RUNNING_STATISTICS";
    private static final String TABLE_JOB_RUNNING_STATISTICS = "JOB_RUNNING_STATISTICS";
    private static final String TABLE_JOB_REGISTER_STATISTICS = "JOB_REGISTER_STATISTICS";
    private final DataSource dataSource;
    private final boolean enable;

    public StatisticRdbRepository(DataSource dataSource, boolean enable) {
        this.dataSource = dataSource;
        this.enable = enable;
    }

    public boolean add(TaskResultStatistics taskResultStatistics) {
        boolean result = false;
        String sql = "INSERT INTO `TASK_RESULT_STATISTICS_" + taskResultStatistics.getStatisticInterval() + "` (`success_count`, `failed_count`, `statistics_time`, `creation_time`) VALUES (?, ?, ?, ?);";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setInt(1, taskResultStatistics.getSuccessCount());
            preparedStatement.setInt(2, taskResultStatistics.getFailedCount());
            preparedStatement.setTimestamp(3, new Timestamp(taskResultStatistics.getStatisticsTime().getTime()));
            preparedStatement.setTimestamp(4, new Timestamp(taskResultStatistics.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error("Insert taskResultStatistics to DB error:", (Throwable)ex);
        }
        return result;
    }

    public boolean add(TaskRunningStatistics taskRunningStatistics) {
        boolean result = false;
        String sql = "INSERT INTO `TASK_RUNNING_STATISTICS` (`running_count`, `statistics_time`, `creation_time`) VALUES (?, ?, ?);";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setInt(1, taskRunningStatistics.getRunningCount());
            preparedStatement.setTimestamp(2, new Timestamp(taskRunningStatistics.getStatisticsTime().getTime()));
            preparedStatement.setTimestamp(3, new Timestamp(taskRunningStatistics.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error("Insert taskRunningStatistics to DB error:", (Throwable)ex);
        }
        return result;
    }

    public boolean add(JobRunningStatistics jobRunningStatistics) {
        boolean result = false;
        String sql = "INSERT INTO `JOB_RUNNING_STATISTICS` (`running_count`, `statistics_time`, `creation_time`) VALUES (?, ?, ?);";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setInt(1, jobRunningStatistics.getRunningCount());
            preparedStatement.setTimestamp(2, new Timestamp(jobRunningStatistics.getStatisticsTime().getTime()));
            preparedStatement.setTimestamp(3, new Timestamp(jobRunningStatistics.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error("Insert jobRunningStatistics to DB error:", (Throwable)ex);
        }
        return result;
    }

    public boolean add(JobRegisterStatistics jobRegisterStatistics) {
        boolean result = false;
        String sql = "INSERT INTO `JOB_REGISTER_STATISTICS` (`registered_count`, `statistics_time`, `creation_time`) VALUES (?, ?, ?);";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setInt(1, jobRegisterStatistics.getRegisteredCount());
            preparedStatement.setTimestamp(2, new Timestamp(jobRegisterStatistics.getStatisticsTime().getTime()));
            preparedStatement.setTimestamp(3, new Timestamp(jobRegisterStatistics.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error("Insert jobRegisterStatistics to DB error:", (Throwable)ex);
        }
        return result;
    }

    public List<TaskResultStatistics> findTaskResultStatistics(Date from, StatisticInterval statisticInterval) {
        LinkedList<TaskResultStatistics> result = new LinkedList<TaskResultStatistics>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = String.format("SELECT id, success_count, failed_count, statistics_time, creation_time FROM %s WHERE statistics_time >= '%s' order by id ASC", "TASK_RESULT_STATISTICS_" + statisticInterval, formatter.format(from));
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                TaskResultStatistics taskResultStatistics = new TaskResultStatistics(resultSet.getLong(1), resultSet.getInt(2), resultSet.getInt(3), statisticInterval, new Date(resultSet.getTimestamp(4).getTime()), new Date(resultSet.getTimestamp(5).getTime()));
                result.add(taskResultStatistics);
            }
        }
        catch (SQLException ex) {
            log.error("Fetch taskResultStatistics from DB error:", (Throwable)ex);
        }
        return result;
    }

    public TaskResultStatistics getSummedTaskResultStatistics(Date from, StatisticInterval statisticInterval) {
        TaskResultStatistics result = new TaskResultStatistics(0, 0, statisticInterval, new Date());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = String.format("SELECT sum(success_count), sum(failed_count) FROM %s WHERE statistics_time >= '%s'", "TASK_RESULT_STATISTICS_" + statisticInterval, formatter.format(from));
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result = new TaskResultStatistics(resultSet.getInt(1), resultSet.getInt(2), statisticInterval, new Date());
            }
        }
        catch (SQLException ex) {
            log.error("Fetch summed taskResultStatistics from DB error:", (Throwable)ex);
        }
        return result;
    }

    public Optional<TaskResultStatistics> findLatestTaskResultStatistics(StatisticInterval statisticInterval) {
        TaskResultStatistics result = null;
        String sql = String.format("SELECT id, success_count, failed_count, statistics_time, creation_time FROM %s order by id DESC LIMIT 1", "TASK_RESULT_STATISTICS_" + statisticInterval);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result = new TaskResultStatistics(resultSet.getLong(1), resultSet.getInt(2), resultSet.getInt(3), statisticInterval, new Date(resultSet.getTimestamp(4).getTime()), new Date(resultSet.getTimestamp(5).getTime()));
            }
        }
        catch (SQLException ex) {
            log.error("Fetch latest taskResultStatistics from DB error:", (Throwable)ex);
        }
        return Optional.ofNullable(result);
    }

    public List<TaskRunningStatistics> findTaskRunningStatistics(Date from) {
        LinkedList<TaskRunningStatistics> result = new LinkedList<TaskRunningStatistics>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = String.format("SELECT id, running_count, statistics_time, creation_time FROM %s WHERE statistics_time >= '%s' order by id ASC", TABLE_TASK_RUNNING_STATISTICS, formatter.format(from));
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                TaskRunningStatistics taskRunningStatistics = new TaskRunningStatistics(resultSet.getLong(1), resultSet.getInt(2), new Date(resultSet.getTimestamp(3).getTime()), new Date(resultSet.getTimestamp(4).getTime()));
                result.add(taskRunningStatistics);
            }
        }
        catch (SQLException ex) {
            log.error("Fetch taskRunningStatistics from DB error:", (Throwable)ex);
        }
        return result;
    }

    public List<JobRunningStatistics> findJobRunningStatistics(Date from) {
        LinkedList<JobRunningStatistics> result = new LinkedList<JobRunningStatistics>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = String.format("SELECT id, running_count, statistics_time, creation_time FROM %s WHERE statistics_time >= '%s' order by id ASC", TABLE_JOB_RUNNING_STATISTICS, formatter.format(from));
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JobRunningStatistics jobRunningStatistics = new JobRunningStatistics(resultSet.getLong(1), resultSet.getInt(2), new Date(resultSet.getTimestamp(3).getTime()), new Date(resultSet.getTimestamp(4).getTime()));
                result.add(jobRunningStatistics);
            }
        }
        catch (SQLException ex) {
            log.error("Fetch jobRunningStatistics from DB error:", (Throwable)ex);
        }
        return result;
    }

    public Optional<TaskRunningStatistics> findLatestTaskRunningStatistics() {
        TaskRunningStatistics result = null;
        String sql = String.format("SELECT id, running_count, statistics_time, creation_time FROM %s order by id DESC LIMIT 1", TABLE_TASK_RUNNING_STATISTICS);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result = new TaskRunningStatistics(resultSet.getLong(1), resultSet.getInt(2), new Date(resultSet.getTimestamp(3).getTime()), new Date(resultSet.getTimestamp(4).getTime()));
            }
        }
        catch (SQLException ex) {
            log.error("Fetch latest taskRunningStatistics from DB error:", (Throwable)ex);
        }
        return Optional.ofNullable(result);
    }

    public Optional<JobRunningStatistics> findLatestJobRunningStatistics() {
        JobRunningStatistics result = null;
        String sql = String.format("SELECT id, running_count, statistics_time, creation_time FROM %s order by id DESC LIMIT 1", TABLE_JOB_RUNNING_STATISTICS);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result = new JobRunningStatistics(resultSet.getLong(1), resultSet.getInt(2), new Date(resultSet.getTimestamp(3).getTime()), new Date(resultSet.getTimestamp(4).getTime()));
            }
        }
        catch (SQLException ex) {
            log.error("Fetch latest jobRunningStatistics from DB error:", (Throwable)ex);
        }
        return Optional.ofNullable(result);
    }

    public List<JobRegisterStatistics> findJobRegisterStatistics(Date from) {
        LinkedList<JobRegisterStatistics> result = new LinkedList<JobRegisterStatistics>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = String.format("SELECT id, registered_count, statistics_time, creation_time FROM %s WHERE statistics_time >= '%s' order by id ASC", TABLE_JOB_REGISTER_STATISTICS, formatter.format(from));
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JobRegisterStatistics jobRegisterStatistics = new JobRegisterStatistics(resultSet.getLong(1), resultSet.getInt(2), new Date(resultSet.getTimestamp(3).getTime()), new Date(resultSet.getTimestamp(4).getTime()));
                result.add(jobRegisterStatistics);
            }
        }
        catch (SQLException ex) {
            log.error("Fetch jobRegisterStatistics from DB error:", (Throwable)ex);
        }
        return result;
    }

    public Optional<JobRegisterStatistics> findLatestJobRegisterStatistics() {
        JobRegisterStatistics result = null;
        String sql = String.format("SELECT id, registered_count, statistics_time, creation_time FROM %s order by id DESC LIMIT 1", TABLE_JOB_REGISTER_STATISTICS);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result = new JobRegisterStatistics(resultSet.getLong(1), resultSet.getInt(2), new Date(resultSet.getTimestamp(3).getTime()), new Date(resultSet.getTimestamp(4).getTime()));
            }
        }
        catch (SQLException ex) {
            log.error("Fetch latest jobRegisterStatistics from DB error:", (Throwable)ex);
        }
        return Optional.ofNullable(result);
    }

    public boolean isEnable() {
        return this.enable;
    }
}

