/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Utility;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    ConstantValue(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)1, n, n2, constantPool);
        this.constantvalue_index = n3;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantValue(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    @Override
    public final String toString() {
        String string;
        Constant constant = this.cpool.getConstant(this.constantvalue_index);
        switch (constant.getTag()) {
            case 5: {
                string = "" + ((ConstantLong)constant).getValue();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getValue();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getValue();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getValue();
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.cpool.getConstant(n, (byte)1);
                string = "\"" + Utility.convertString(((ConstantUtf8)constant).getValue()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + constant);
            }
        }
        return string;
    }
}

