/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.security.AccessController;
import org.apache.openjpa.lib.meta.XMLMetaDataParser;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CFMetaDataParser
extends XMLMetaDataParser {
    static final String[] PACKAGES = new String[]{"java.lang.", "java.util.", "java.math."};
    private static final Localizer _loc = Localizer.forPackage(CFMetaDataParser.class);
    private String _package = null;
    private String _class = null;

    public CFMetaDataParser() {
        this.setParseText(false);
    }

    protected boolean isPackageElementName(String name) {
        return "package".equals(name);
    }

    protected String getPackageAttributeName() {
        return "name";
    }

    protected int getPackageElementDepth() {
        return 1;
    }

    protected boolean isClassElementName(String name) {
        return "class".equals(name);
    }

    protected String getClassAttributeName() {
        return "name";
    }

    protected int getClassElementDepth() {
        return 2;
    }

    @Override
    protected boolean startElement(String name, Attributes attrs) throws SAXException {
        int depth = this.currentDepth();
        if (depth == 0) {
            return true;
        }
        if (StringUtil.contains(name, ':')) {
            int index = name.indexOf(58);
            name = name.substring(index + 1);
        }
        try {
            if (this._openjpaNamespace > 0) {
                if (name.equals("entity")) {
                    return this.startExtendedClass(name, attrs);
                }
                if (name.equals("attributes")) {
                    return true;
                }
                return this.startClassElement(name, attrs);
            }
            if (depth == this.getPackageElementDepth() && this.isPackageElementName(name)) {
                return this.startPackage(name, attrs);
            }
            if (depth == this.getClassElementDepth() && this.isClassElementName(name)) {
                return this.startClass(name, attrs);
            }
            if (depth > this.getClassElementDepth() && this._class != null && this.getClassAttributeName() != null) {
                return this.startClassElement(name, attrs);
            }
            if (depth > this.getPackageElementDepth() && this._package != null && this.getPackageAttributeName() != null) {
                return this.startPackageElement(name, attrs);
            }
            return this.startSystemElement(name, attrs);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (NullPointerException npe) {
            throw this.getException(_loc.get("parse-error", name), npe);
        }
    }

    @Override
    protected void endElement(String name) throws SAXException {
        int depth = this.currentDepth();
        if (depth == 0) {
            return;
        }
        if (StringUtil.contains(name, ':')) {
            int index = name.indexOf(58);
            name = name.substring(index + 1);
        }
        try {
            if (this._openjpaNamespace > 0) {
                if (name.equals("entity")) {
                    this.endExtendedClass(name);
                } else if (!name.equals("attributes")) {
                    this.endClassElement(name);
                }
            } else if (depth == this.getPackageElementDepth() && this.isPackageElementName(name)) {
                this.endPackage(name);
            } else if (depth == this.getClassElementDepth() && this.isClassElementName(name)) {
                this.endClass(name);
            } else if (depth > this.getClassElementDepth() && this._class != null && this.getClassAttributeName() != null) {
                this.endClassElement(name);
            } else if (depth > this.getPackageElementDepth() && this._package != null && this.getPackageAttributeName() != null) {
                this.endPackageElement(name);
            } else {
                this.endSystemElement(name);
            }
        }
        catch (SAXException se) {
            throw se;
        }
        catch (NullPointerException npe) {
            throw this.getException(_loc.get("parse-error", name), npe);
        }
    }

    protected boolean startPackage(String elem, Attributes attrs) throws SAXException {
        if (this.getPackageAttributeName() != null) {
            this._package = attrs.getValue(this.getPackageAttributeName());
            if (this._package == null) {
                this._package = "";
            }
        }
        return true;
    }

    protected void endPackage(String elem) {
        this._package = this.getPackageAttributeName() != null ? null : this.currentText();
    }

    protected boolean startClass(String elem, Attributes attrs) throws SAXException {
        if (this.getClassAttributeName() != null) {
            this._class = attrs.getValue(this.getClassAttributeName());
            if (!StringUtil.isEmpty(this._package) && this._class.indexOf(46) == -1) {
                this._class = this._package + "." + this._class;
            }
        }
        return true;
    }

    protected void endClass(String elem) throws SAXException {
        if (this.getClassAttributeName() != null) {
            this._class = null;
        } else {
            this._class = this.currentText();
            if (!StringUtil.isEmpty(this._package) && this._class.indexOf(46) == -1) {
                this._class = this._package + "." + this._class;
            }
        }
    }

    protected boolean startExtendedClass(String elem, Attributes attrs) throws SAXException {
        return false;
    }

    protected void endExtendedClass(String elem) throws SAXException {
    }

    protected boolean startSystemElement(String name, Attributes attrs) throws SAXException {
        return false;
    }

    protected void endSystemElement(String name) throws SAXException {
    }

    protected boolean startPackageElement(String name, Attributes attrs) throws SAXException {
        return false;
    }

    protected void endPackageElement(String name) throws SAXException {
    }

    protected boolean startClassElement(String name, Attributes attrs) throws SAXException {
        return false;
    }

    protected void endClassElement(String name) throws SAXException {
    }

    @Override
    protected void reset() {
        super.reset();
        this._package = null;
        this._class = null;
    }

    protected String currentClassName() {
        return this._class;
    }

    protected String currentPackage() {
        return this._package;
    }

    protected Class<?> classForName(String name, boolean resolve) throws SAXException {
        if (name == null) {
            return null;
        }
        Class<?> cls = CFMetaDataParser.classForName(name, this._package, resolve, this.currentClassLoader());
        if (cls == null) {
            throw this.getException(_loc.get("invalid-class", name).getMessage());
        }
        return cls;
    }

    public static Class<?> classForName(String name, String pkg, boolean resolve, ClassLoader loader) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        boolean fullName = name.indexOf(46) != -1;
        boolean noPackage = StringUtil.isEmpty(pkg);
        try {
            if (fullName || noPackage) {
                return ClassUtil.toClass(name, resolve, loader);
            }
            return ClassUtil.toClass(pkg + "." + name, resolve, loader);
        }
        catch (RuntimeException runtimeException) {
            if (!fullName && !noPackage) {
                try {
                    return ClassUtil.toClass(name, resolve, loader);
                }
                catch (RuntimeException runtimeException2) {
                    // empty catch block
                }
            }
            if (!fullName) {
                for (int i = 0; i < PACKAGES.length; ++i) {
                    try {
                        return ClassUtil.toClass(PACKAGES[i] + name, resolve, loader);
                    }
                    catch (RuntimeException runtimeException3) {
                        continue;
                    }
                }
            }
            return null;
        }
    }
}

