/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadUserDataItem is the corresponding interface of S7PayloadUserDataItem
type S7PayloadUserDataItem interface {
	S7PayloadUserDataItemContract
	S7PayloadUserDataItemRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsS7PayloadUserDataItem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadUserDataItem()
	// CreateBuilder creates a S7PayloadUserDataItemBuilder
	CreateS7PayloadUserDataItemBuilder() S7PayloadUserDataItemBuilder
}

// S7PayloadUserDataItemContract provides a set of functions which can be overwritten by a sub struct
type S7PayloadUserDataItemContract interface {
	// GetReturnCode returns ReturnCode (property field)
	GetReturnCode() DataTransportErrorCode
	// GetTransportSize returns TransportSize (property field)
	GetTransportSize() DataTransportSize
	// GetDataLength returns DataLength (property field)
	GetDataLength() uint16
	// IsS7PayloadUserDataItem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadUserDataItem()
	// CreateBuilder creates a S7PayloadUserDataItemBuilder
	CreateS7PayloadUserDataItemBuilder() S7PayloadUserDataItemBuilder
}

// S7PayloadUserDataItemRequirements provides a set of functions which need to be implemented by a sub struct
type S7PayloadUserDataItemRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetCpuFunctionGroup returns CpuFunctionGroup (discriminator field)
	GetCpuFunctionGroup() uint8
	// GetCpuFunctionType returns CpuFunctionType (discriminator field)
	GetCpuFunctionType() uint8
	// GetCpuSubfunction returns CpuSubfunction (discriminator field)
	GetCpuSubfunction() uint8
	// GetDataLength returns DataLength (discriminator field)
	GetDataLength() uint16
}

// _S7PayloadUserDataItem is the data-structure of this message
type _S7PayloadUserDataItem struct {
	_SubType interface {
		S7PayloadUserDataItemContract
		S7PayloadUserDataItemRequirements
	}
	ReturnCode    DataTransportErrorCode
	TransportSize DataTransportSize
	DataLength    uint16
}

var _ S7PayloadUserDataItemContract = (*_S7PayloadUserDataItem)(nil)

// NewS7PayloadUserDataItem factory function for _S7PayloadUserDataItem
func NewS7PayloadUserDataItem(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) *_S7PayloadUserDataItem {
	return &_S7PayloadUserDataItem{ReturnCode: returnCode, TransportSize: transportSize, DataLength: dataLength}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadUserDataItemBuilder is a builder for S7PayloadUserDataItem
type S7PayloadUserDataItemBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) S7PayloadUserDataItemBuilder
	// WithReturnCode adds ReturnCode (property field)
	WithReturnCode(DataTransportErrorCode) S7PayloadUserDataItemBuilder
	// WithTransportSize adds TransportSize (property field)
	WithTransportSize(DataTransportSize) S7PayloadUserDataItemBuilder
	// WithDataLength adds DataLength (property field)
	WithDataLength(uint16) S7PayloadUserDataItemBuilder
	// AsS7PayloadUserDataItemCyclicServicesPush converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesPush() S7PayloadUserDataItemCyclicServicesPushBuilder
	// AsS7PayloadUserDataItemCyclicServicesChangeDrivenPush converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesChangeDrivenPush() S7PayloadUserDataItemCyclicServicesChangeDrivenPushBuilder
	// AsS7PayloadUserDataItemCyclicServicesSubscribeRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesSubscribeRequest() S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder
	// AsS7PayloadUserDataItemCyclicServicesUnsubscribeRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesUnsubscribeRequest() S7PayloadUserDataItemCyclicServicesUnsubscribeRequestBuilder
	// AsS7PayloadUserDataItemCyclicServicesSubscribeResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesSubscribeResponse() S7PayloadUserDataItemCyclicServicesSubscribeResponseBuilder
	// AsS7PayloadUserDataItemCyclicServicesUnsubscribeResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesUnsubscribeResponse() S7PayloadUserDataItemCyclicServicesUnsubscribeResponseBuilder
	// AsS7PayloadUserDataItemCyclicServicesErrorResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesErrorResponse() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder
	// AsS7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse() S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponseBuilder
	// AsS7PayloadDiagnosticMessage converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadDiagnosticMessage() S7PayloadDiagnosticMessageBuilder
	// AsS7PayloadAlarm8 converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadAlarm8() S7PayloadAlarm8Builder
	// AsS7PayloadNotify converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadNotify() S7PayloadNotifyBuilder
	// AsS7PayloadAlarmAckInd converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadAlarmAckInd() S7PayloadAlarmAckIndBuilder
	// AsS7PayloadAlarmSQ converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadAlarmSQ() S7PayloadAlarmSQBuilder
	// AsS7PayloadAlarmS converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadAlarmS() S7PayloadAlarmSBuilder
	// AsS7PayloadAlarmSC converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadAlarmSC() S7PayloadAlarmSCBuilder
	// AsS7PayloadNotify8 converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadNotify8() S7PayloadNotify8Builder
	// AsS7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest() S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequestBuilder
	// AsS7PayloadUserDataItemCpuFunctionReadSzlRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionReadSzlRequest() S7PayloadUserDataItemCpuFunctionReadSzlRequestBuilder
	// AsS7PayloadUserDataItemCpuFunctionReadSzlResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionReadSzlResponse() S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder
	// AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest() S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilder
	// AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse() S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponseBuilder
	// AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse() S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponseBuilder
	// AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse() S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponseBuilder
	// AsS7PayloadUserDataItemCpuFunctionAlarmAckRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionAlarmAckRequest() S7PayloadUserDataItemCpuFunctionAlarmAckRequestBuilder
	// AsS7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse() S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponseBuilder
	// AsS7PayloadUserDataItemCpuFunctionAlarmAckResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionAlarmAckResponse() S7PayloadUserDataItemCpuFunctionAlarmAckResponseBuilder
	// AsS7PayloadUserDataItemCpuFunctionAlarmQueryRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionAlarmQueryRequest() S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilder
	// AsS7PayloadUserDataItemCpuFunctionAlarmQueryResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemCpuFunctionAlarmQueryResponse() S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder
	// AsS7PayloadUserDataItemClkRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemClkRequest() S7PayloadUserDataItemClkRequestBuilder
	// AsS7PayloadUserDataItemClkResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemClkResponse() S7PayloadUserDataItemClkResponseBuilder
	// AsS7PayloadUserDataItemClkFRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemClkFRequest() S7PayloadUserDataItemClkFRequestBuilder
	// AsS7PayloadUserDataItemClkFResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemClkFResponse() S7PayloadUserDataItemClkFResponseBuilder
	// AsS7PayloadUserDataItemClkSetRequest converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemClkSetRequest() S7PayloadUserDataItemClkSetRequestBuilder
	// AsS7PayloadUserDataItemClkSetResponse converts this build to a subType of S7PayloadUserDataItem. It is always possible to return to current builder using Done()
	AsS7PayloadUserDataItemClkSetResponse() S7PayloadUserDataItemClkSetResponseBuilder
	// Build builds the S7PayloadUserDataItem or returns an error if something is wrong
	PartialBuild() (S7PayloadUserDataItemContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() S7PayloadUserDataItemContract
	// Build builds the S7PayloadUserDataItem or returns an error if something is wrong
	Build() (S7PayloadUserDataItem, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadUserDataItem
}

// NewS7PayloadUserDataItemBuilder() creates a S7PayloadUserDataItemBuilder
func NewS7PayloadUserDataItemBuilder() S7PayloadUserDataItemBuilder {
	return &_S7PayloadUserDataItemBuilder{_S7PayloadUserDataItem: new(_S7PayloadUserDataItem)}
}

type _S7PayloadUserDataItemChildBuilder interface {
	utils.Copyable
	setParent(S7PayloadUserDataItemContract)
	buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error)
}

type _S7PayloadUserDataItemBuilder struct {
	*_S7PayloadUserDataItem

	childBuilder _S7PayloadUserDataItemChildBuilder

	collectedErr []error
}

var _ (S7PayloadUserDataItemBuilder) = (*_S7PayloadUserDataItemBuilder)(nil)

func (b *_S7PayloadUserDataItemBuilder) WithMandatoryFields(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) S7PayloadUserDataItemBuilder {
	return b.WithReturnCode(returnCode).WithTransportSize(transportSize).WithDataLength(dataLength)
}

func (b *_S7PayloadUserDataItemBuilder) WithReturnCode(returnCode DataTransportErrorCode) S7PayloadUserDataItemBuilder {
	b.ReturnCode = returnCode
	return b
}

func (b *_S7PayloadUserDataItemBuilder) WithTransportSize(transportSize DataTransportSize) S7PayloadUserDataItemBuilder {
	b.TransportSize = transportSize
	return b
}

func (b *_S7PayloadUserDataItemBuilder) WithDataLength(dataLength uint16) S7PayloadUserDataItemBuilder {
	b.DataLength = dataLength
	return b
}

func (b *_S7PayloadUserDataItemBuilder) PartialBuild() (S7PayloadUserDataItemContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._S7PayloadUserDataItem.deepCopy(), nil
}

func (b *_S7PayloadUserDataItemBuilder) PartialMustBuild() S7PayloadUserDataItemContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesPush() S7PayloadUserDataItemCyclicServicesPushBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesPushBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesPushBuilder().(*_S7PayloadUserDataItemCyclicServicesPushBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesChangeDrivenPush() S7PayloadUserDataItemCyclicServicesChangeDrivenPushBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesChangeDrivenPushBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesChangeDrivenPushBuilder().(*_S7PayloadUserDataItemCyclicServicesChangeDrivenPushBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesSubscribeRequest() S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder().(*_S7PayloadUserDataItemCyclicServicesSubscribeRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesUnsubscribeRequest() S7PayloadUserDataItemCyclicServicesUnsubscribeRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesUnsubscribeRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesUnsubscribeRequestBuilder().(*_S7PayloadUserDataItemCyclicServicesUnsubscribeRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesSubscribeResponse() S7PayloadUserDataItemCyclicServicesSubscribeResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesSubscribeResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesSubscribeResponseBuilder().(*_S7PayloadUserDataItemCyclicServicesSubscribeResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesUnsubscribeResponse() S7PayloadUserDataItemCyclicServicesUnsubscribeResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesUnsubscribeResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesUnsubscribeResponseBuilder().(*_S7PayloadUserDataItemCyclicServicesUnsubscribeResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesErrorResponse() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesErrorResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesErrorResponseBuilder().(*_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse() S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponseBuilder().(*_S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadDiagnosticMessage() S7PayloadDiagnosticMessageBuilder {
	if cb, ok := b.childBuilder.(S7PayloadDiagnosticMessageBuilder); ok {
		return cb
	}
	cb := NewS7PayloadDiagnosticMessageBuilder().(*_S7PayloadDiagnosticMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadAlarm8() S7PayloadAlarm8Builder {
	if cb, ok := b.childBuilder.(S7PayloadAlarm8Builder); ok {
		return cb
	}
	cb := NewS7PayloadAlarm8Builder().(*_S7PayloadAlarm8Builder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadNotify() S7PayloadNotifyBuilder {
	if cb, ok := b.childBuilder.(S7PayloadNotifyBuilder); ok {
		return cb
	}
	cb := NewS7PayloadNotifyBuilder().(*_S7PayloadNotifyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadAlarmAckInd() S7PayloadAlarmAckIndBuilder {
	if cb, ok := b.childBuilder.(S7PayloadAlarmAckIndBuilder); ok {
		return cb
	}
	cb := NewS7PayloadAlarmAckIndBuilder().(*_S7PayloadAlarmAckIndBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadAlarmSQ() S7PayloadAlarmSQBuilder {
	if cb, ok := b.childBuilder.(S7PayloadAlarmSQBuilder); ok {
		return cb
	}
	cb := NewS7PayloadAlarmSQBuilder().(*_S7PayloadAlarmSQBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadAlarmS() S7PayloadAlarmSBuilder {
	if cb, ok := b.childBuilder.(S7PayloadAlarmSBuilder); ok {
		return cb
	}
	cb := NewS7PayloadAlarmSBuilder().(*_S7PayloadAlarmSBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadAlarmSC() S7PayloadAlarmSCBuilder {
	if cb, ok := b.childBuilder.(S7PayloadAlarmSCBuilder); ok {
		return cb
	}
	cb := NewS7PayloadAlarmSCBuilder().(*_S7PayloadAlarmSCBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadNotify8() S7PayloadNotify8Builder {
	if cb, ok := b.childBuilder.(S7PayloadNotify8Builder); ok {
		return cb
	}
	cb := NewS7PayloadNotify8Builder().(*_S7PayloadNotify8Builder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest() S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionReadSzlNoDataRequestBuilder().(*_S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionReadSzlRequest() S7PayloadUserDataItemCpuFunctionReadSzlRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionReadSzlRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionReadSzlRequestBuilder().(*_S7PayloadUserDataItemCpuFunctionReadSzlRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionReadSzlResponse() S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionReadSzlResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest() S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilder().(*_S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse() S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionMsgSubscriptionResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse() S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse() S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionAlarmAckRequest() S7PayloadUserDataItemCpuFunctionAlarmAckRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionAlarmAckRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionAlarmAckRequestBuilder().(*_S7PayloadUserDataItemCpuFunctionAlarmAckRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse() S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionAlarmAckErrorResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionAlarmAckResponse() S7PayloadUserDataItemCpuFunctionAlarmAckResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionAlarmAckResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionAlarmAckResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionAlarmAckResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionAlarmQueryRequest() S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilder().(*_S7PayloadUserDataItemCpuFunctionAlarmQueryRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemCpuFunctionAlarmQueryResponse() S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder().(*_S7PayloadUserDataItemCpuFunctionAlarmQueryResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemClkRequest() S7PayloadUserDataItemClkRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemClkRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemClkRequestBuilder().(*_S7PayloadUserDataItemClkRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemClkResponse() S7PayloadUserDataItemClkResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemClkResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemClkResponseBuilder().(*_S7PayloadUserDataItemClkResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemClkFRequest() S7PayloadUserDataItemClkFRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemClkFRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemClkFRequestBuilder().(*_S7PayloadUserDataItemClkFRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemClkFResponse() S7PayloadUserDataItemClkFResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemClkFResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemClkFResponseBuilder().(*_S7PayloadUserDataItemClkFResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemClkSetRequest() S7PayloadUserDataItemClkSetRequestBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemClkSetRequestBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemClkSetRequestBuilder().(*_S7PayloadUserDataItemClkSetRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) AsS7PayloadUserDataItemClkSetResponse() S7PayloadUserDataItemClkSetResponseBuilder {
	if cb, ok := b.childBuilder.(S7PayloadUserDataItemClkSetResponseBuilder); ok {
		return cb
	}
	cb := NewS7PayloadUserDataItemClkSetResponseBuilder().(*_S7PayloadUserDataItemClkSetResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7PayloadUserDataItemBuilder) Build() (S7PayloadUserDataItem, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForS7PayloadUserDataItem()
}

func (b *_S7PayloadUserDataItemBuilder) MustBuild() S7PayloadUserDataItem {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadUserDataItemBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_S7PayloadUserDataItemChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateS7PayloadUserDataItemBuilder creates a S7PayloadUserDataItemBuilder
func (b *_S7PayloadUserDataItem) CreateS7PayloadUserDataItemBuilder() S7PayloadUserDataItemBuilder {
	if b == nil {
		return NewS7PayloadUserDataItemBuilder()
	}
	return &_S7PayloadUserDataItemBuilder{_S7PayloadUserDataItem: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7PayloadUserDataItem) GetReturnCode() DataTransportErrorCode {
	return m.ReturnCode
}

func (m *_S7PayloadUserDataItem) GetTransportSize() DataTransportSize {
	return m.TransportSize
}

func (m *_S7PayloadUserDataItem) GetDataLength() uint16 {
	return m.DataLength
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7PayloadUserDataItem(structType any) S7PayloadUserDataItem {
	if casted, ok := structType.(S7PayloadUserDataItem); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadUserDataItem); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadUserDataItem) GetTypeName() string {
	return "S7PayloadUserDataItem"
}

func (m *_S7PayloadUserDataItem) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (returnCode)
	lengthInBits += 8

	// Simple field (transportSize)
	lengthInBits += 8

	// Simple field (dataLength)
	lengthInBits += 16

	return lengthInBits
}

func (m *_S7PayloadUserDataItem) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_S7PayloadUserDataItem) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func S7PayloadUserDataItemParse[T S7PayloadUserDataItem](ctx context.Context, theBytes []byte, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (T, error) {
	return S7PayloadUserDataItemParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
}

func S7PayloadUserDataItemParseWithBufferProducer[T S7PayloadUserDataItem](cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := S7PayloadUserDataItemParseWithBuffer[T](ctx, readBuffer, cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func S7PayloadUserDataItemParseWithBuffer[T S7PayloadUserDataItem](ctx context.Context, readBuffer utils.ReadBuffer, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (T, error) {
	v, err := (&_S7PayloadUserDataItem{}).parse(ctx, readBuffer, cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_S7PayloadUserDataItem) parse(ctx context.Context, readBuffer utils.ReadBuffer, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadUserDataItem S7PayloadUserDataItem, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadUserDataItem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadUserDataItem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	returnCode, err := ReadEnumField[DataTransportErrorCode](ctx, "returnCode", "DataTransportErrorCode", ReadEnum(DataTransportErrorCodeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'returnCode' field"))
	}
	m.ReturnCode = returnCode

	transportSize, err := ReadEnumField[DataTransportSize](ctx, "transportSize", "DataTransportSize", ReadEnum(DataTransportSizeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportSize' field"))
	}
	m.TransportSize = transportSize

	dataLength, err := ReadSimpleField(ctx, "dataLength", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataLength' field"))
	}
	m.DataLength = dataLength

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child S7PayloadUserDataItem
	switch {
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x00 && cpuSubfunction == 0x01: // S7PayloadUserDataItemCyclicServicesPush
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesPush).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesPush for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x00 && cpuSubfunction == 0x05: // S7PayloadUserDataItemCyclicServicesChangeDrivenPush
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesChangeDrivenPush).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesChangeDrivenPush for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x04 && cpuSubfunction == 0x01: // S7PayloadUserDataItemCyclicServicesSubscribeRequest
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesSubscribeRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesSubscribeRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x04 && cpuSubfunction == 0x04: // S7PayloadUserDataItemCyclicServicesUnsubscribeRequest
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesUnsubscribeRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesUnsubscribeRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x08 && cpuSubfunction == 0x01: // S7PayloadUserDataItemCyclicServicesSubscribeResponse
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesSubscribeResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesSubscribeResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x08 && cpuSubfunction == 0x04: // S7PayloadUserDataItemCyclicServicesUnsubscribeResponse
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesUnsubscribeResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesUnsubscribeResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x08 && cpuSubfunction == 0x05 && dataLength == 0x00: // S7PayloadUserDataItemCyclicServicesErrorResponse
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesErrorResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesErrorResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x02 && cpuFunctionType == 0x08 && cpuSubfunction == 0x05: // S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse
		if _child, err = new(_S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x03: // S7PayloadDiagnosticMessage
		if _child, err = new(_S7PayloadDiagnosticMessage).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadDiagnosticMessage for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x05: // S7PayloadAlarm8
		if _child, err = new(_S7PayloadAlarm8).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadAlarm8 for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x06: // S7PayloadNotify
		if _child, err = new(_S7PayloadNotify).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadNotify for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x0c: // S7PayloadAlarmAckInd
		if _child, err = new(_S7PayloadAlarmAckInd).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadAlarmAckInd for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x11: // S7PayloadAlarmSQ
		if _child, err = new(_S7PayloadAlarmSQ).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadAlarmSQ for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x12: // S7PayloadAlarmS
		if _child, err = new(_S7PayloadAlarmS).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadAlarmS for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x13: // S7PayloadAlarmSC
		if _child, err = new(_S7PayloadAlarmSC).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadAlarmSC for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x00 && cpuSubfunction == 0x16: // S7PayloadNotify8
		if _child, err = new(_S7PayloadNotify8).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadNotify8 for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x04 && cpuSubfunction == 0x01 && dataLength == 0x00: // S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionReadSzlNoDataRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x04 && cpuSubfunction == 0x01: // S7PayloadUserDataItemCpuFunctionReadSzlRequest
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionReadSzlRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionReadSzlRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x01: // S7PayloadUserDataItemCpuFunctionReadSzlResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionReadSzlResponse).parse(ctx, readBuffer, m, dataLength, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionReadSzlResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x04 && cpuSubfunction == 0x02: // S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x02 && dataLength == 0x00: // S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionMsgSubscriptionResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x02 && dataLength == 0x02: // S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x02 && dataLength == 0x05: // S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x04 && cpuSubfunction == 0x0b: // S7PayloadUserDataItemCpuFunctionAlarmAckRequest
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionAlarmAckRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionAlarmAckRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x0b && dataLength == 0x00: // S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionAlarmAckErrorResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x0b: // S7PayloadUserDataItemCpuFunctionAlarmAckResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionAlarmAckResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionAlarmAckResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x04 && cpuSubfunction == 0x13: // S7PayloadUserDataItemCpuFunctionAlarmQueryRequest
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionAlarmQueryRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionAlarmQueryRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x04 && cpuFunctionType == 0x08 && cpuSubfunction == 0x13: // S7PayloadUserDataItemCpuFunctionAlarmQueryResponse
		if _child, err = new(_S7PayloadUserDataItemCpuFunctionAlarmQueryResponse).parse(ctx, readBuffer, m, dataLength, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemCpuFunctionAlarmQueryResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x07 && cpuFunctionType == 0x04 && cpuSubfunction == 0x01: // S7PayloadUserDataItemClkRequest
		if _child, err = new(_S7PayloadUserDataItemClkRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemClkRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x07 && cpuFunctionType == 0x08 && cpuSubfunction == 0x01: // S7PayloadUserDataItemClkResponse
		if _child, err = new(_S7PayloadUserDataItemClkResponse).parse(ctx, readBuffer, m, dataLength, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemClkResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x07 && cpuFunctionType == 0x04 && cpuSubfunction == 0x03: // S7PayloadUserDataItemClkFRequest
		if _child, err = new(_S7PayloadUserDataItemClkFRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemClkFRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x07 && cpuFunctionType == 0x08 && cpuSubfunction == 0x03: // S7PayloadUserDataItemClkFResponse
		if _child, err = new(_S7PayloadUserDataItemClkFResponse).parse(ctx, readBuffer, m, dataLength, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemClkFResponse for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x07 && cpuFunctionType == 0x04 && cpuSubfunction == 0x04: // S7PayloadUserDataItemClkSetRequest
		if _child, err = new(_S7PayloadUserDataItemClkSetRequest).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemClkSetRequest for type-switch of S7PayloadUserDataItem")
		}
	case cpuFunctionGroup == 0x07 && cpuFunctionType == 0x08 && cpuSubfunction == 0x04: // S7PayloadUserDataItemClkSetResponse
		if _child, err = new(_S7PayloadUserDataItemClkSetResponse).parse(ctx, readBuffer, m, cpuFunctionGroup, cpuFunctionType, cpuSubfunction); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7PayloadUserDataItemClkSetResponse for type-switch of S7PayloadUserDataItem")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [cpuFunctionGroup=%v, cpuFunctionType=%v, cpuSubfunction=%v, dataLength=%v]", cpuFunctionGroup, cpuFunctionType, cpuSubfunction, dataLength)
	}

	if closeErr := readBuffer.CloseContext("S7PayloadUserDataItem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadUserDataItem")
	}

	return _child, nil
}

func (pm *_S7PayloadUserDataItem) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child S7PayloadUserDataItem, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("S7PayloadUserDataItem"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for S7PayloadUserDataItem")
	}

	if err := WriteSimpleEnumField[DataTransportErrorCode](ctx, "returnCode", "DataTransportErrorCode", m.GetReturnCode(), WriteEnum[DataTransportErrorCode, uint8](DataTransportErrorCode.GetValue, DataTransportErrorCode.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'returnCode' field")
	}

	if err := WriteSimpleEnumField[DataTransportSize](ctx, "transportSize", "DataTransportSize", m.GetTransportSize(), WriteEnum[DataTransportSize, uint8](DataTransportSize.GetValue, DataTransportSize.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'transportSize' field")
	}

	if err := WriteSimpleField[uint16](ctx, "dataLength", m.GetDataLength(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'dataLength' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("S7PayloadUserDataItem"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for S7PayloadUserDataItem")
	}
	return nil
}

func (m *_S7PayloadUserDataItem) IsS7PayloadUserDataItem() {}

func (m *_S7PayloadUserDataItem) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadUserDataItem) deepCopy() *_S7PayloadUserDataItem {
	if m == nil {
		return nil
	}
	_S7PayloadUserDataItemCopy := &_S7PayloadUserDataItem{
		nil, // will be set by child
		m.ReturnCode,
		m.TransportSize,
		m.DataLength,
	}
	return _S7PayloadUserDataItemCopy
}
