/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FlateFilterDecoderStream;
import org.apache.pdfbox.filter.Predictor;
import org.apache.pdfbox.io.IOUtils;

final class FlateFilter
extends Filter {
    FlateFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        COSDictionary decodeParams = this.getDecodeParams(parameters, index);
        try (FlateFilterDecoderStream decoderStream = new FlateFilterDecoderStream(encoded);){
            OutputStream wrapPredictor = Predictor.wrapPredictor(decoded, decodeParams);
            IOUtils.copy(decoderStream, wrapPredictor);
            wrapPredictor.flush();
        }
        return new DecodeResult(parameters);
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        int compressionLevel = FlateFilter.getCompressionLevel();
        Deflater deflater = new Deflater(compressionLevel);
        try (DeflaterOutputStream out = new DeflaterOutputStream(encoded, deflater);){
            IOUtils.copy(input, out);
        }
        encoded.flush();
        deflater.end();
    }
}

