/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLLongint
extends NumberDataType {
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLLongint.class);
    private long value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 127L || this.value < -128L) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if (this.value > 32767L || this.value < -32768L) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0L;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getTypeName() {
        return "BIGINT";
    }

    @Override
    public int getTypeFormatId() {
        return 84;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readLong();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0L;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        long l;
        long l2 = this.getLong();
        if (l2 == (l = dataValueDescriptor.getLong())) {
            return 0;
        }
        if (l2 > l) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLLongint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLLongint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getLong(n);
        this.isnull = this.value == 0L ? bl && resultSet.wasNull() : false;
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, -5);
            return;
        }
        preparedStatement.setLong(n, this.value);
    }

    @Override
    public final void setInto(ResultSet resultSet, int n) throws SQLException {
        resultSet.updateLong(n, this.value);
    }

    public SQLLongint() {
        this.isnull = true;
    }

    public SQLLongint(long l) {
        this.value = l;
    }

    private SQLLongint(long l, boolean bl) {
        this.value = l;
        this.isnull = bl;
    }

    public SQLLongint(Long l) {
        this.isnull = l == null;
        if (!this.isnull) {
            this.value = l;
        }
    }

    @Override
    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0L;
            this.isnull = true;
        } else {
            try {
                this.value = Long.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public final void setValue(Number number) {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.longValue());
    }

    @Override
    public void setValue(long l) {
        this.value = l;
        this.isnull = false;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
        this.isnull = false;
    }

    @Override
    public void setValue(float f) throws StandardException {
        if ((f = NumberDataType.normalizeREAL(f)) > 9.223372E18f || f < -9.223372E18f) {
            throw StandardException.newException("22003", "BIGINT");
        }
        float f2 = (float)Math.floor(f);
        this.value = (long)f2;
        this.isnull = false;
    }

    @Override
    public void setValue(double d) throws StandardException {
        if ((d = NumberDataType.normalizeDOUBLE(d)) > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        double d2 = Math.floor(d);
        this.value = (long)d2;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean bl) {
        this.value = bl ? 1L : 0L;
        this.isnull = false;
    }

    @Override
    void setObject(Object object) {
        this.setValue((Long)object);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getLong());
    }

    @Override
    public int typePrecedence() {
        return 60;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() == dataValueDescriptor2.getLong());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() != dataValueDescriptor2.getLong());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() < dataValueDescriptor2.getLong());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() > dataValueDescriptor2.getLong());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() <= dataValueDescriptor2.getLong());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() >= dataValueDescriptor2.getLong());
    }

    @Override
    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong();
        long l2 = numberDataValue2.getLong();
        long l3 = l + l2;
        if (l < 0L == l2 < 0L && l < 0L != l3 < 0L) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue3.setValue(l3);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong() - numberDataValue2.getLong();
        if (numberDataValue.getLong() < 0L != numberDataValue2.getLong() < 0L && numberDataValue.getLong() < 0L != l < 0L) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue3.setValue(l);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong() * numberDataValue2.getLong();
        if (numberDataValue2.getLong() != 0L && numberDataValue.getLong() != l / numberDataValue2.getLong()) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue3.setValue(l);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue2.getLong();
        if (l == 0L) {
            throw StandardException.newException("22012", new Object[0]);
        }
        numberDataValue3.setValue(numberDataValue.getLong() / l);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue2.getLong();
        if (l == 0L) {
            throw StandardException.newException("22012", new Object[0]);
        }
        numberDataValue3.setValue(numberDataValue.getLong() % l);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLLongint();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        long l = this.getLong();
        if (l == Long.MIN_VALUE) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue.setValue(-l);
        return numberDataValue;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0L;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

