/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.ElementType;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang3.reflect.TypeUtils;

public class IndexedAccess
extends AccessStrategy {
    private static final TypeVariable<?> ITERABLE_TYPE = Iterable.class.getTypeParameters()[0];
    private Type containerType;
    private Integer index;

    public static Type getJavaElementType(Type containerType) {
        if (TypeUtils.isArrayType(containerType)) {
            return TypeUtils.getArrayComponentType(containerType);
        }
        if (TypeUtils.isAssignable(containerType, Iterable.class)) {
            Map<TypeVariable<?>, Type> typeArguments = TypeUtils.getTypeArguments(containerType, Iterable.class);
            return typeArguments.containsKey(ITERABLE_TYPE) ? typeArguments.get(ITERABLE_TYPE) : Object.class;
        }
        return null;
    }

    public IndexedAccess(Type containerType, Integer index) {
        this.containerType = containerType;
        this.index = index;
    }

    public Object get(Object instance) {
        if (this.index == null) {
            throw new UnsupportedOperationException("Cannot read null index");
        }
        if (instance != null && instance.getClass().isArray()) {
            if (Array.getLength(instance) - this.index > 0) {
                return Array.get(instance, this.index);
            }
        } else if (instance instanceof List) {
            List list = (List)instance;
            if (list.size() - this.index > 0) {
                return list.get(this.index);
            }
        } else if (instance instanceof Iterable) {
            int i = 0;
            for (Object o : (Iterable)instance) {
                if (++i != this.index) continue;
                return o;
            }
        }
        return null;
    }

    public ElementType getElementType() {
        return ElementType.METHOD;
    }

    public Type getJavaType() {
        return IndexedAccess.getJavaElementType(this.containerType);
    }

    public String getPropertyName() {
        return String.format("[%d]", this.index);
    }
}

