/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.ClearFieldManager;
import org.apache.openjpa.kernel.SingleFieldManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ProxyManager;

public class SaveFieldManager
extends ClearFieldManager
implements Serializable {
    private final StateManagerImpl _sm;
    private final BitSet _unloaded;
    private BitSet _saved = null;
    private int[] _copyField = null;
    private transient PersistenceCapable _state = null;
    private Object _field = null;

    SaveFieldManager(StateManagerImpl sm, PersistenceCapable pc, BitSet dirty) {
        this._sm = sm;
        this._state = pc;
        FieldMetaData[] fields = this._sm.getMetaData().getFields();
        if (this._sm.isNew() || !this._sm.isPersistent() || dirty == null) {
            this._unloaded = new BitSet(fields.length);
        } else {
            this._unloaded = (BitSet)dirty.clone();
            for (int i = 0; i < fields.length; ++i) {
                FieldMetaData cfr_ignored_0 = fields[i];
                if (fields[i].getManagement() == 3) continue;
                this._unloaded.clear(i);
            }
        }
    }

    public PersistenceCapable getState() {
        return this._state;
    }

    public BitSet getUnloaded() {
        return this._unloaded;
    }

    public boolean saveField(int field) {
        int restore;
        if (this._sm.getLoaded() != null && !this._sm.getLoaded().get(field)) {
            this._unloaded.set(field);
            return false;
        }
        if (this._saved != null && this._saved.get(field)) {
            return false;
        }
        FieldMetaData fmd = this._sm.getMetaData().getField(field);
        boolean mutable = false;
        switch (fmd.getDeclaredTypeCode()) {
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                mutable = true;
            }
        }
        if ((this._sm.getBroker().getInverseManager() == null || fmd.getInverseMetaDatas().length == 0) && ((restore = this._sm.getBroker().getRestoreState()) == 0 || mutable && restore == 1)) {
            this._unloaded.set(field);
            return false;
        }
        if (this._state == null) {
            this._state = this._sm.getPersistenceCapable().pcNewInstance(this._sm, true);
        }
        if (this._saved == null) {
            this._saved = new BitSet(this._sm.getMetaData().getFields().length);
        }
        this._saved.set(field);
        if (mutable) {
            return true;
        }
        if (this._copyField == null) {
            this._copyField = new int[1];
        }
        this._copyField[0] = field;
        this.getState().pcCopyFields(this._sm.getPersistenceCapable(), this._copyField);
        return false;
    }

    public boolean restoreField(int field) {
        if (this._unloaded.get(field)) {
            return true;
        }
        if (this._saved == null || !this._saved.get(field)) {
            return false;
        }
        if (this._copyField == null) {
            this._copyField = new int[1];
        }
        this._copyField[0] = field;
        this._sm.getPersistenceCapable().pcCopyFields(this.getState(), this._copyField);
        return false;
    }

    public boolean isFieldEqual(int field, Object current) {
        if (this._saved == null || !this._saved.get(field)) {
            return false;
        }
        if (!(this.getState().pcGetStateManager() instanceof StateManagerImpl)) {
            return false;
        }
        StateManagerImpl sm = (StateManagerImpl)this.getState().pcGetStateManager();
        SingleFieldManager single = new SingleFieldManager(sm, sm.getBroker());
        sm.provideField(this.getState(), single, field);
        Object old = single.fetchObjectField(field);
        return current == old || current != null && current.equals(old);
    }

    @Override
    public Object fetchObjectField(int field) {
        return this._field;
    }

    @Override
    public void storeObjectField(int field, Object curVal) {
        ProxyManager proxy2 = this._sm.getBroker().getConfiguration().getProxyManagerInstance();
        FieldMetaData fmd = this._sm.getMetaData().getField(field);
        switch (fmd.getDeclaredTypeCode()) {
            case 11: {
                this._field = proxy2.copyArray(curVal);
                break;
            }
            case 12: {
                this._field = proxy2.copyCollection((Collection)curVal);
                break;
            }
            case 13: {
                this._field = proxy2.copyMap((Map)curVal);
                break;
            }
            case 14: {
                this._field = proxy2.copyDate((Date)curVal);
                break;
            }
            case 8: {
                this._field = proxy2.copyCustom(curVal);
                if (this._field != null) break;
                this._field = curVal;
                break;
            }
            default: {
                this._field = curVal;
            }
        }
        if (curVal != null && this._field == null) {
            this._unloaded.set(field);
            this._saved.clear(field);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        this._sm.writePC(oos, this._state);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this._state = this._sm.readPC(ois);
    }
}

