/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.apache.bval.jsr303.ConstraintFinderImpl;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementDescriptorImpl
implements ElementDescriptor {
    protected final MetaBean metaBean;
    protected final Class<?> elementClass;
    private Set<ConstraintDescriptor<?>> constraintDescriptors;

    protected static Set<ConstraintDescriptor<?>> getConstraintDescriptors(Validation[] validations) {
        HashSet result = new HashSet(validations.length);
        for (Validation validation : validations) {
            if (!(validation instanceof ConstraintValidation)) continue;
            result.add((ConstraintValidation)validation);
        }
        return result;
    }

    protected ElementDescriptorImpl(MetaBean metaBean, Class<?> elementClass, Validation[] validations) {
        this.metaBean = metaBean;
        this.elementClass = elementClass;
        this.setConstraintDescriptors(ElementDescriptorImpl.getConstraintDescriptors(validations));
    }

    protected ElementDescriptorImpl(Class<?> elementClass, Validation[] validations) {
        this(null, elementClass, validations);
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public ElementDescriptor.ConstraintFinder findConstraints() {
        return new ConstraintFinderImpl(this.metaBean, new HashSet(this.constraintDescriptors));
    }

    @Override
    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraintDescriptors.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.constraintDescriptors);
    }

    protected Set<ConstraintDescriptor<?>> getMutableConstraintDescriptors() {
        return this.constraintDescriptors;
    }

    @Override
    public boolean hasConstraints() {
        return !this.getConstraintDescriptors().isEmpty();
    }

    public void setConstraintDescriptors(Set<ConstraintDescriptor<?>> constraintDescriptors) {
        this.constraintDescriptors = constraintDescriptors;
    }

    public MetaBean getMetaBean() {
        return this.metaBean;
    }
}

