<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
# Security Vulnerability Disclosure

Apache NiFi welcomes the responsible reporting of security vulnerabilities. The NiFi team believes that working with skilled security researchers across the globe is crucial in identifying weaknesses in any technology. If you believe you've found a security issue in our product or service, we encourage you to notify us. We will work with you to resolve the issue promptly.

## Table of Contents

* [Disclosure Policy](#disclosure-policy)
* [Exclusions](#exclusions)
* [Reporting Methods](#reporting-methods)
* [Publishing](#publishing)

## Disclosure Policy

* Let us know as soon as possible upon discovery of a potential security issue, and we'll make every effort to quickly resolve the issue.
* Provide us a reasonable amount of time to resolve the issue before any disclosure to the public or a third-party.
* Make a good faith effort to avoid privacy violations, destruction of data, and interruption or degradation of our service. Only interact with accounts you own or with explicit permission of the account holder.

## Exclusions

While researching, we'd like to ask you to refrain from:
* Denial of service
* Spamming
* Social engineering (including phishing) of Apache NiFi staff or contractors
* Any physical attempts against Apache NiFi property or data centers

## Reporting Methods

* NiFi Security Mailing List: [security@nifi.apache.org](mailto:security@nifi.apache.org)
  * Members of the [Project Management Committee](https://nifi.apache.org/people.html) monitor this private mailing list and respond to disclosures

## Publishing

Apache NiFi follows the [ASF Project Security For Committers](https://www.apache.org/security/committers.html) policy. Thus, any vulnerability is not disclosed by the project until a released version which mitigates the issue is available for download. Once this release is available, the issue is fully documented in the following locations:
* An email is sent to the same addresses as the release announcement (dev@nifi.apache.org, users@nifi.apache.org, announce@apache.org), security@nifi.apache.org, and oss-security@lists.openwall.com
* The [Mitre Common Vulnerabilities and Exposures (CVE) database](https://cveform.mitre.org/)
* The [Apache NiFi Security Page](https://nifi.apache.org/security.html)

Thank you for helping keep Apache NiFi and our users safe!