/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * AccidentalAssignmentCustomizer.java
 *
 * Created on Sep 16, 2008, 11:44:39 AM
 */

package org.netbeans.modules.php.editor.verification;

import java.util.prefs.Preferences;

/**
 *
 * @author Tomasz.Slota@Sun.COM
 */
public class AccidentalAssignmentCustomizer extends javax.swing.JPanel {
    private final AccidentalAssignmentHint accidentalAssignmentHint;
    private final Preferences preferences;

    /* Creates new form AccidentalAssignmentCustomizer */
    public AccidentalAssignmentCustomizer(Preferences preferences, AccidentalAssignmentHint accidentalAssignmentHint) {
        this.preferences = preferences;
        this.accidentalAssignmentHint = accidentalAssignmentHint;
        initComponents();
        checkAssignmentsInWhileStatementsCheckBox.setSelected(accidentalAssignmentHint.checkAssignmentsInWhileStatements(preferences));
        checkAssignmentsInSubStatementsCheckBox.setSelected(accidentalAssignmentHint.checkAssignmentsInSubStatements(preferences));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        checkAssignmentsInWhileStatementsCheckBox = new javax.swing.JCheckBox();
        checkAssignmentsInSubStatementsCheckBox = new javax.swing.JCheckBox();

        checkAssignmentsInWhileStatementsCheckBox.setMnemonic('a');
        checkAssignmentsInWhileStatementsCheckBox.setText(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.includeWhileCB.text")); // NOI18N
        checkAssignmentsInWhileStatementsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkAssignmentsInWhileStatementsCheckBoxActionPerformed(evt);
            }
        });

        checkAssignmentsInSubStatementsCheckBox.setMnemonic('C');
        checkAssignmentsInSubStatementsCheckBox.setText(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.checkAssignmentsInSubStatementsCheckBox.text")); // NOI18N
        checkAssignmentsInSubStatementsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkAssignmentsInSubStatementsCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(checkAssignmentsInSubStatementsCheckBox)
                    .addComponent(checkAssignmentsInWhileStatementsCheckBox))
                .addContainerGap(108, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(checkAssignmentsInSubStatementsCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(checkAssignmentsInWhileStatementsCheckBox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        checkAssignmentsInWhileStatementsCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.cbIncludeWhile.AccessibleContext.accessibleName")); // NOI18N
        checkAssignmentsInWhileStatementsCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.cbIncludeWhile.AccessibleContext.accessibleDescription")); // NOI18N
        checkAssignmentsInSubStatementsCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.chkTopLvlStmtOnly.AccessibleContext.accessibleName")); // NOI18N
        checkAssignmentsInSubStatementsCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.chkTopLvlStmtOnly.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AccidentalAssignmentCustomizer.class, "AccidentalAssignmentCustomizer.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void checkAssignmentsInWhileStatementsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkAssignmentsInWhileStatementsCheckBoxActionPerformed
        accidentalAssignmentHint.setCheckAssignmentsInWhileStatements(preferences, checkAssignmentsInWhileStatementsCheckBox.isSelected());
    }//GEN-LAST:event_checkAssignmentsInWhileStatementsCheckBoxActionPerformed

    private void checkAssignmentsInSubStatementsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkAssignmentsInSubStatementsCheckBoxActionPerformed
        accidentalAssignmentHint.setCheckAssignmentsInSubStatements(preferences, checkAssignmentsInSubStatementsCheckBox.isSelected());
}//GEN-LAST:event_checkAssignmentsInSubStatementsCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox checkAssignmentsInSubStatementsCheckBox;
    private javax.swing.JCheckBox checkAssignmentsInWhileStatementsCheckBox;
    // End of variables declaration//GEN-END:variables

}
