/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.modules.java.hints.suggestions.IfToSwitchSupport;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ConvertIfToSwitch {
    public static final int DEFAULT_OPTION_IF_SWITCH_BRANCH_THRESHOLD = 3;
    public static final boolean DEFAULT_OPTION_GENERATE_EMPTY_DEFAULT = true;
    public static final String OPTION_IF_SWITCH_BRANCH_THRESHOLD = "iftoswitch.branch.threshold";
    public static final String OPTION_GENERATE_EMPTY_DEFAULT = "iftoswitch.generate.default";
    private static final String[] PATTERNS_INIT = new String[]{"$c1.equals($c2)", "$c1 == $c2"};
    private static final String[] PATTERNS_EQ = new String[]{"$var.equals($constant)", "$constant.equals($var)", "$var.contentEquals($constant)", "$constant.contentEquals($var)"};
    private static final String[] PATTERNS_ID = new String[]{"$var == $constant", "$constant == $var"};

    public static List<ErrorDescription> convertIfToSwitch(final HintContext ctx) {
        TreePath parent = ctx.getPath().getParentPath();
        if (parent.getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        IfToSwitchSupport eval = new IfToSwitchSupport(ctx){
            boolean controlTypeChecked;
            {
                super(ctx2);
                this.controlTypeChecked = false;
            }

            @Override
            protected TypeMirror acceptArgType(TypeMirror controlType, TypeMirror argType) {
                if (!this.controlTypeChecked) {
                    if (!controlType.getKind().isPrimitive() && !Utilities.isPrimitiveWrapperType(argType)) {
                        if (controlType.getKind() != TypeKind.DECLARED) {
                            return null;
                        }
                        Element el = ((DeclaredType)controlType).asElement();
                        if (el == null || el.getKind() != ElementKind.ENUM) {
                            return null;
                        }
                    }
                    this.controlTypeChecked = true;
                }
                return super.acceptArgType(controlType, argType);
            }

            @Override
            protected TreePath matches(TreePath test, boolean initial) {
                for (String pat : PATTERNS_INIT) {
                    if (!MatcherUtilities.matches(ctx, test, pat, true)) continue;
                    TreePath c1 = ctx.getVariables().get("$c1");
                    this.reportConstantAndLiteral(c1, ctx.getVariables().get("$c2"));
                    return c1;
                }
                return null;
            }

            @Override
            protected TreePath matchesChainedItem(TreePath test, TreePath variable) {
                ArrayList<String> pats = new ArrayList<String>(Arrays.asList(PATTERNS_ID));
                if (this.getVariableMirror().getKind() == TypeKind.DECLARED) {
                    pats.addAll(Arrays.asList(PATTERNS_EQ));
                }
                ctx.getVariables().put("$var", variable);
                ctx.getVariables().remove("$constant");
                ctx.getVariableNames().remove("$constant");
                for (String pat : pats) {
                    if (!MatcherUtilities.matches(ctx, test, pat, true)) continue;
                    TreePath constPath = ctx.getVariables().get("$constant");
                    TreePath varPath = ctx.getVariables().get("$var$1");
                    if (varPath.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
                        this.controlVariableNotNull();
                    }
                    return constPath;
                }
                return null;
            }
        };
        if (!eval.process(ctx.getVariables().get("$cond1"))) {
            return null;
        }
        if (eval.containsDuplicateConstants()) {
            Map<TreePath, Object> duplicates = eval.getDuplicateConstants();
            ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>(duplicates.size());
            HashSet<Object> s = new HashSet<Object>();
            for (Map.Entry<TreePath, Object> en : duplicates.entrySet()) {
                Object lit = en.getValue();
                if (!s.add(lit)) continue;
                TreePath t = en.getKey();
                descs.add(ErrorDescriptionFactory.forTree(ctx, t, Bundle.TEXT_ChainedIfContainsSameValues(lit), new Fix[0]));
            }
            return descs;
        }
        if (eval.getNumberOfBranches() < ctx.getPreferences().getInt(OPTION_IF_SWITCH_BRANCH_THRESHOLD, 3)) {
            return null;
        }
        Fix convert = eval.createFix(Bundle.FIX_ConvertIfsToSwitch(), ctx.getPreferences().getBoolean(OPTION_GENERATE_EMPTY_DEFAULT, true)).toEditorFix();
        return Collections.singletonList(ErrorDescriptionFactory.forTree(ctx, ctx.getVariables().get("$body").getParentPath(), NbBundle.getMessage(ConvertIfToSwitch.class, "HINT_ConvertIfToSwitch"), convert));
    }
}

