/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.jdk.RegexExampleAction;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="CheckRegexTopComponent", iconBase="org/netbeans/modules/java/hints/resources/regexp.png", persistenceType=0)
public final class CheckRegexTopComponent
extends TopComponent {
    private static CheckRegexTopComponent instance;
    private static final String PREFERRED_ID = "CheckRegexTopComponent";
    private static boolean isStrictMatch;
    private static int Flags;
    private JCheckBoxMenuItem canonEqMenuItem;
    private JCheckBoxMenuItem caseInsensitiveMenuItem;
    private JCheckBoxMenuItem commentsMenuItem;
    private JCheckBoxMenuItem dotAllMenuItem;
    private JLabel errorLabel;
    private JLayeredPane exampleLayeredPane;
    private JScrollPane exampleScrollPane;
    private JTextArea exampleTextArea;
    private JButton flagsButton;
    private JPopupMenu flagsPopupMenu;
    private JLabel iconLabel;
    private JCheckBoxMenuItem literalMenuItem;
    private JCheckBoxMenuItem multilineMenuItem;
    private JPanel regexPanel;
    private JScrollPane regexScrollPane;
    private JTextArea regexTextArea;
    private JCheckBox strictCheckBox;
    private JCheckBoxMenuItem unicodeCaseMenuItem;
    private JCheckBoxMenuItem unicodeCharacterClassMenuItem;
    private JCheckBoxMenuItem unixLinesMenuItem;
    private JSplitPane verticalSplitPane;

    public CheckRegexTopComponent() {
        this.initComponents();
        this.errorLabel.setVisible(false);
        this.setName(Bundle.CTL_CheckRegexTopComponent());
        this.setToolTipText(Bundle.HINT_CheckRegexTopComponent());
        isStrictMatch = false;
    }

    private void initComponents() {
        this.flagsPopupMenu = new JPopupMenu();
        this.multilineMenuItem = new JCheckBoxMenuItem();
        this.literalMenuItem = new JCheckBoxMenuItem();
        this.dotAllMenuItem = new JCheckBoxMenuItem();
        this.caseInsensitiveMenuItem = new JCheckBoxMenuItem();
        this.commentsMenuItem = new JCheckBoxMenuItem();
        this.unixLinesMenuItem = new JCheckBoxMenuItem();
        this.canonEqMenuItem = new JCheckBoxMenuItem();
        this.unicodeCaseMenuItem = new JCheckBoxMenuItem();
        this.unicodeCharacterClassMenuItem = new JCheckBoxMenuItem();
        this.flagsButton = new JButton();
        JButton examplesButton = new JButton();
        this.strictCheckBox = new JCheckBox();
        this.verticalSplitPane = new JSplitPane();
        this.regexPanel = new JPanel();
        JLabel regexLabel = new JLabel();
        this.regexScrollPane = new JScrollPane();
        this.regexTextArea = new JTextArea();
        this.errorLabel = new JLabel();
        JPanel examplePanel = new JPanel();
        JLabel exampleLabel = new JLabel();
        this.exampleLayeredPane = new JLayeredPane();
        this.iconLabel = new JLabel();
        this.exampleScrollPane = new JScrollPane();
        this.exampleTextArea = new JTextArea();
        Mnemonics.setLocalizedText(this.multilineMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.multilineMenuItem.text"));
        this.multilineMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.multilineMenuItem.toolTipText"));
        this.multilineMenuItem.addActionListener(this::multilineMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.multilineMenuItem);
        Mnemonics.setLocalizedText(this.literalMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.literalMenuItem.text"));
        this.literalMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.literalMenuItem.toolTipText"));
        this.literalMenuItem.addActionListener(this::literalMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.literalMenuItem);
        Mnemonics.setLocalizedText(this.dotAllMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.dotAllMenuItem.text"));
        this.dotAllMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.dotAllMenuItem.toolTipText"));
        this.dotAllMenuItem.addActionListener(this::dotAllMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.dotAllMenuItem);
        Mnemonics.setLocalizedText(this.caseInsensitiveMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.caseInsensitiveMenuItem.text"));
        this.caseInsensitiveMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.caseInsensitiveMenuItem.toolTipText"));
        this.caseInsensitiveMenuItem.addActionListener(this::caseInsensitiveMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.caseInsensitiveMenuItem);
        Mnemonics.setLocalizedText(this.commentsMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.commentsMenuItem.text"));
        this.commentsMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.commentsMenuItem.toolTipText"));
        this.commentsMenuItem.addActionListener(this::commentsMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.commentsMenuItem);
        Mnemonics.setLocalizedText(this.unixLinesMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.unixLinesMenuItem.text"));
        this.unixLinesMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.unixLinesMenuItem.toolTipText"));
        this.unixLinesMenuItem.addActionListener(this::unixLinesMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.unixLinesMenuItem);
        Mnemonics.setLocalizedText(this.canonEqMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.canonEqMenuItem.text"));
        this.canonEqMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.canonEqMenuItem.toolTipText"));
        this.canonEqMenuItem.addActionListener(this::canonEqMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.canonEqMenuItem);
        Mnemonics.setLocalizedText(this.unicodeCaseMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.unicodeCaseMenuItem.text"));
        this.unicodeCaseMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.unicodeCaseMenuItem.toolTipText"));
        this.unicodeCaseMenuItem.addActionListener(this::unicodeCaseMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.unicodeCaseMenuItem);
        Mnemonics.setLocalizedText(this.unicodeCharacterClassMenuItem, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.unicodeCharacterClassMenuItem.text"));
        this.unicodeCharacterClassMenuItem.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.unicodeCharacterClassMenuItem.toolTipText"));
        this.unicodeCharacterClassMenuItem.addActionListener(this::unicodeCharacterClassMenuItemActionPerformed);
        this.flagsPopupMenu.add(this.unicodeCharacterClassMenuItem);
        Mnemonics.setLocalizedText(this.flagsButton, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.flagsButton.text"));
        this.flagsButton.addActionListener(this::flagsButtonActionPerformed);
        Mnemonics.setLocalizedText(examplesButton, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.examplesButton.text"));
        examplesButton.addActionListener(this::examplesButtonActionPerformed);
        Mnemonics.setLocalizedText(this.strictCheckBox, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.strictCheckBox.text"));
        this.strictCheckBox.setToolTipText(NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.strictCheckBox.toolTipText"));
        this.strictCheckBox.addItemListener(this::strictCheckBoxItemStateChanged);
        this.verticalSplitPane.setDividerLocation(80);
        this.verticalSplitPane.setOrientation(0);
        this.regexPanel.setPreferredSize(new Dimension(517, 80));
        Mnemonics.setLocalizedText(regexLabel, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.regexLabel.text"));
        this.regexScrollPane.setMinimumSize(new Dimension(6, 30));
        this.regexScrollPane.setPreferredSize(new Dimension(164, 74));
        this.regexTextArea.setColumns(20);
        this.regexTextArea.setRows(5);
        this.regexTextArea.setFocusAccelerator('g');
        this.regexTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CheckRegexTopComponent.this.regexTextAreaKeyReleased(evt);
            }
        });
        this.regexScrollPane.setViewportView(this.regexTextArea);
        this.errorLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText(this.errorLabel, "dummy error message");
        GroupLayout regexPanelLayout = new GroupLayout(this.regexPanel);
        this.regexPanel.setLayout(regexPanelLayout);
        regexPanelLayout.setHorizontalGroup(regexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(regexPanelLayout.createSequentialGroup().addContainerGap().addGroup(regexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regexScrollPane, -1, 441, Short.MAX_VALUE).addGroup(regexPanelLayout.createSequentialGroup().addComponent(regexLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.errorLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        regexPanelLayout.setVerticalGroup(regexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(regexPanelLayout.createSequentialGroup().addContainerGap().addComponent(regexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regexScrollPane, -1, 30, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
        this.verticalSplitPane.setTopComponent(this.regexPanel);
        Mnemonics.setLocalizedText(exampleLabel, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.exampleLabel.text"));
        this.exampleLayeredPane.setMinimumSize(new Dimension(0, 40));
        this.exampleScrollPane.setOpaque(false);
        this.exampleTextArea.setColumns(20);
        this.exampleTextArea.setRows(5);
        this.exampleTextArea.setFocusAccelerator('x');
        this.exampleTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CheckRegexTopComponent.this.exampleTextAreaKeyReleased(evt);
            }
        });
        this.exampleScrollPane.setViewportView(this.exampleTextArea);
        this.exampleLayeredPane.setLayer(this.iconLabel, JLayeredPane.DEFAULT_LAYER);
        this.exampleLayeredPane.setLayer(this.exampleScrollPane, JLayeredPane.DEFAULT_LAYER);
        GroupLayout exampleLayeredPaneLayout = new GroupLayout(this.exampleLayeredPane);
        this.exampleLayeredPane.setLayout(exampleLayeredPaneLayout);
        exampleLayeredPaneLayout.setHorizontalGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, exampleLayeredPaneLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.iconLabel, -2, 17, -2).addContainerGap()).addGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exampleScrollPane, -1, 278, Short.MAX_VALUE)));
        exampleLayeredPaneLayout.setVerticalGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleLayeredPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.iconLabel, -2, 18, -2).addContainerGap(42, Short.MAX_VALUE)).addGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleLayeredPaneLayout.createSequentialGroup().addComponent(this.exampleScrollPane, -1, 86, Short.MAX_VALUE).addContainerGap())));
        GroupLayout examplePanelLayout = new GroupLayout(examplePanel);
        examplePanel.setLayout(examplePanelLayout);
        examplePanelLayout.setHorizontalGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(examplePanelLayout.createSequentialGroup().addContainerGap().addGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exampleLayeredPane, -1, -1, Short.MAX_VALUE).addGroup(examplePanelLayout.createSequentialGroup().addComponent(exampleLabel).addGap(0, 386, Short.MAX_VALUE))).addContainerGap()));
        examplePanelLayout.setVerticalGroup(examplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(examplePanelLayout.createSequentialGroup().addContainerGap().addComponent(exampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exampleLayeredPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.verticalSplitPane.setRightComponent(examplePanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.flagsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(examplesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.strictCheckBox).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.verticalSplitPane, -1, 453, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.verticalSplitPane, -1, 186, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.flagsButton).addComponent(examplesButton).addComponent(this.strictCheckBox)).addContainerGap()));
    }

    private void exampleTextAreaKeyReleased(KeyEvent evt) {
        if (this.exampleTextArea.getSelectedText() == null) {
            this.matchPattern();
        }
    }

    private void regexTextAreaKeyReleased(KeyEvent evt) {
        this.matchPattern();
    }

    private void strictCheckBoxItemStateChanged(ItemEvent evt) {
        isStrictMatch = !isStrictMatch;
        this.matchPattern();
    }

    private void flagsButtonActionPerformed(ActionEvent evt) {
        if (this.flagsPopupMenu.isVisible()) {
            this.flagsPopupMenu.setVisible(false);
        } else {
            this.flagsPopupMenu.show(this.flagsButton, 0, (int)(0.0 - this.flagsPopupMenu.getPreferredSize().getHeight()));
        }
    }

    private void caseInsensitiveMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.caseInsensitiveMenuItem.isSelected() ? (Flags |= 2) : (Flags &= 0xFFFFFFFD);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void multilineMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.multilineMenuItem.isSelected() ? (Flags |= 8) : (Flags &= 0xFFFFFFF7);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void dotAllMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.dotAllMenuItem.isSelected() ? (Flags |= 0x20) : (Flags &= 0xFFFFFFDF);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void unicodeCaseMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.unicodeCaseMenuItem.isSelected() ? (Flags |= 0x40) : (Flags &= 0xFFFFFFBF);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void unicodeCharacterClassMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.unicodeCharacterClassMenuItem.isSelected() ? (Flags |= 0x100) : (Flags &= 0xFFFFFEFF);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void commentsMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.commentsMenuItem.isSelected() ? (Flags |= 4) : (Flags &= 0xFFFFFFFB);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void literalMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.literalMenuItem.isSelected() ? (Flags |= 0x10) : (Flags &= 0xFFFFFFEF);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void unixLinesMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.unixLinesMenuItem.isSelected() ? (Flags |= 1) : (Flags &= 0xFFFFFFFE);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void canonEqMenuItemActionPerformed(ActionEvent evt) {
        Flags = this.canonEqMenuItem.isSelected() ? (Flags |= 0x80) : (Flags &= 0xFFFFFF7F);
        this.flagsPopupMenu.show(this.flagsButton, 0, 0 - this.flagsPopupMenu.getHeight());
        this.matchPattern();
    }

    private void examplesButtonActionPerformed(ActionEvent evt) {
        try {
            Pattern.compile(this.regexTextArea.getText());
        }
        catch (PatternSyntaxException pse) {
            this.errorLabel.setText(Bundle.CheckRegexTopComponent_label_error(pse.getDescription()));
            return;
        }
        RegexExampleAction regexExampleAction = new RegexExampleAction();
        regexExampleAction.actionPerformed(evt);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public static synchronized CheckRegexTopComponent getDefault() {
        Mode outputMode;
        if (instance == null) {
            instance = new CheckRegexTopComponent();
        }
        if ((outputMode = WindowManager.getDefault().findMode("output")) != null) {
            outputMode.dockInto(instance);
        }
        return instance;
    }

    public static synchronized CheckRegexTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CheckRegexTopComponent.class.getName()).warning("Cannot find CheckRegexTopComponent component. It will not be located properly in the window system.");
            return CheckRegexTopComponent.getDefault();
        }
        if (win instanceof CheckRegexTopComponent) {
            CheckRegexTopComponent regexTC = (CheckRegexTopComponent)win;
            return regexTC;
        }
        Logger.getLogger(CheckRegexTopComponent.class.getName()).warning("There seem to be multiple components with the 'CheckRegexTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CheckRegexTopComponent.getDefault();
    }

    void setData(String origString) {
        this.regexTextArea.setText(origString);
        this.matchPattern();
    }

    private void matchPattern() {
        Pattern p;
        Highlighter highlighter = this.exampleTextArea.getHighlighter();
        highlighter.removeAllHighlights();
        this.iconLabel.setIcon(null);
        if (this.regexTextArea.getText().isEmpty() || this.exampleTextArea.getText().isEmpty()) {
            return;
        }
        try {
            p = Pattern.compile(this.regexTextArea.getText(), Flags);
            this.errorLabel.setVisible(false);
        }
        catch (PatternSyntaxException pse) {
            this.errorLabel.setText(Bundle.CheckRegexTopComponent_label_error(pse.getDescription()));
            this.errorLabel.setVisible(true);
            if (this.regexPanel.getHeight() < this.regexPanel.getPreferredSize().height) {
                this.verticalSplitPane.resetToPreferredSizes();
            }
            return;
        }
        Matcher m = p.matcher(this.exampleTextArea.getText());
        if (m.matches()) {
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/match.png")));
            this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_match_regex());
        } else if (m.hitEnd()) {
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/half-match.png")));
            this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_need_more_input());
        } else if (isStrictMatch) {
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/no-match.png")));
            this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_not_match());
        } else {
            m.reset();
            long count = 0L;
            try {
                while (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = count % 2L == 0L ? new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN) : new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
                    highlighter.addHighlight(start, end, defaultHighlightPainter);
                    ++count;
                }
                if (count > 0L) {
                    this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/match.png")));
                    this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltop_sub_match(count));
                } else {
                    this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/no-match.png")));
                    this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_not_match());
                }
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace(e);
            }
        }
    }

    public String getExpression() {
        return this.regexTextArea.getText();
    }

    static {
        Flags = 0;
    }
}

