/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Map;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.IncompatibleMask;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ShiftOutOfRange {
    public static ErrorDescription checkShiftOutOfRange(HintContext ctx) {
        TreePath identifierTreePath;
        TreePath treePath = ctx.getPath();
        Map<String, TreePath> variables = ctx.getVariables();
        TreePath tree = variables.get("$c");
        Long value = IncompatibleMask.getConstant(tree, ctx);
        if (value == null) {
            return null;
        }
        tree = variables.get("$v");
        if (!(tree.getLeaf() instanceof ExpressionTree)) {
            return null;
        }
        CompilationInfo compilationInfo = ctx.getInfo();
        Trees trees = compilationInfo.getTrees();
        TypeMirror typeMirror = trees.getTypeMirror(identifierTreePath = tree);
        if (!Utilities.isValidType(typeMirror)) {
            return null;
        }
        if (typeMirror.toString().equals("int")) {
            if (value < 0L || value > 31L) {
                return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(ShiftOutOfRange.class, "MSG_ShiftOutOfRange_int"), new Fix[0]);
            }
        } else if (typeMirror.toString().equals("long") && (value < 0L || value > 63L)) {
            return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(ShiftOutOfRange.class, "MSG_ShiftOutOfRange_long"), new Fix[0]);
        }
        return null;
    }
}

