/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.tools.javac.code.ClassFinder;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.jvm.ClassFile;
import jpt.sun.tools.javac.jvm.ClassReader;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;
import jpt30.tools.ForwardingJavaFileObject;
import jpt30.tools.JavaFileObject;
import org.netbeans.lib.nbjavac.services.NBNames;

public class NBClassReader
extends ClassReader {
    private static final Logger LOG = Logger.getLogger(NBClassReader.class.getName());
    private final Names names;
    private final NBNames nbNames;
    private final Log log;

    public static void preRegister(Context context) {
        context.put(classReaderKey, new Context.Factory<ClassReader>(){

            @Override
            public ClassReader make(Context c) {
                return new NBClassReader(c);
            }
        });
    }

    public NBClassReader(Context context) {
        super(context);
        NBAttributeReader[] readers;
        this.names = Names.instance(context);
        this.nbNames = NBNames.instance(context);
        this.log = Log.instance(context);
        for (NBAttributeReader r : readers = new NBAttributeReader[]{new NBAttributeReader(this.nbNames._org_netbeans_EnclosingMethod, ClassFile.Version.V45_3, this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            public void read(Symbol sym, int attrLen) {
                int newbp = NBClassReader.this.bp + attrLen;
                NBClassReader.this.readEnclosingMethodAttr(sym);
                NBClassReader.this.bp = newbp;
            }
        }, new NBAttributeReader(this.nbNames._org_netbeans_SourceLevelAnnotations, ClassFile.Version.V49, this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                NBClassReader.this.attachAnnotations(sym);
            }
        }, new NBAttributeReader(this.nbNames._org_netbeans_SourceLevelParameterAnnotations, ClassFile.Version.V49, this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                NBClassReader.this.attachParameterAnnotations(sym);
            }
        }, new NBAttributeReader(this.nbNames._org_netbeans_SourceLevelTypeAnnotations, ClassFile.Version.V52, this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol sym, int attrLen) {
                NBClassReader.this.attachTypeAnnotations(sym);
            }
        }}) {
            this.attributeReaders.put(r.getName(), r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readClassFile(Symbol.ClassSymbol c) {
        try {
            super.readClassFile(c);
        }
        catch (ClassFinder.BadClassFile cf) {
            if ("compiler.misc.bad.class.file.header".equals(cf.getDiagnostic().getCode())) {
                JavaFileObject origFile = c.classfile;
                try (InputStream in = origFile.openInputStream();){
                    int major;
                    int maxMajor;
                    byte[] data = NBClassReader.readFile(in);
                    if (data.length > 8 && (maxMajor = ClassFile.Version.MAX().major) < (major = (Byte.toUnsignedInt(data[6]) << 8) + Byte.toUnsignedInt(data[7]))) {
                        if (this.log.currentSourceFile() != null) {
                            this.log.warning(0, CompilerProperties.Warnings.BigMajorVersion(origFile, major, maxMajor));
                        }
                        data[6] = (byte)(maxMajor >> 8);
                        data[7] = (byte)(maxMajor & 0xFF);
                        final byte[] dataFin = data;
                        c.classfile = new ForwardingJavaFileObject(origFile){

                            @Override
                            public InputStream openInputStream() throws IOException {
                                return new ByteArrayInputStream(dataFin);
                            }
                        };
                        super.readClassFile(c);
                        return;
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
                finally {
                    c.classfile = origFile;
                }
            }
            throw cf;
        }
    }

    static byte[] readFile(InputStream in) throws IOException {
        int read;
        byte[] data = new byte[Math.max(in.available(), 256)];
        int off = 0;
        while ((read = in.read(data, off, data.length - off)) != -1) {
            if (data.length != (off += read)) continue;
            data = Arrays.copyOf(data, 2 * (data.length + in.available()));
        }
        return Arrays.copyOf(data, off);
    }

    private void attachAnnotations(Symbol sym) {
        try {
            Method m = ClassReader.class.getDeclaredMethod("attachAnnotations", Symbol.class);
            m.setAccessible(true);
            m.invoke((Object)this, sym);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void attachParameterAnnotations(Symbol sym) {
        try {
            Method m = ClassReader.class.getDeclaredMethod("readParameterAnnotations", Symbol.class);
            m.setAccessible(true);
            m.invoke((Object)this, sym);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void attachTypeAnnotations(Symbol sym) {
        try {
            Method m = ClassReader.class.getDeclaredMethod("attachTypeAnnotations", Symbol.class);
            m.setAccessible(true);
            m.invoke((Object)this, sym);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private abstract class NBAttributeReader
    extends ClassReader.AttributeReader {
        private NBAttributeReader(Name name, ClassFile.Version version, Set<ClassReader.AttributeKind> kinds) {
            super(name, version, kinds);
        }

        private Name getName() {
            return this.name;
        }
    }
}

