/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ui;

import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.ProjectProblemsImplementation;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class ProjectProblems {
    private ProjectProblems() {
        throw new IllegalStateException();
    }

    public static boolean isBroken(@NonNull Project project) {
        Parameters.notNull("project", project);
        ProjectProblemsProvider provider = project.getLookup().lookup(ProjectProblemsProvider.class);
        return provider != null && !provider.getProblems().isEmpty();
    }

    public static void showAlert(@NonNull Project project) {
        Parameters.notNull("project", project);
        ProjectProblemsImplementation impl = Lookup.getDefault().lookup(ProjectProblemsImplementation.class);
        if (impl != null) {
            impl.showAlert(project);
        }
    }

    public static void showCustomizer(@NonNull Project project) {
        Parameters.notNull("project", project);
        ProjectProblemsImplementation impl = Lookup.getDefault().lookup(ProjectProblemsImplementation.class);
        if (impl != null) {
            try {
                impl.showCustomizer(project).get();
            }
            catch (InterruptedException ex) {
                throw new CompletionException(ex);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof Error) {
                    throw (Error)ex.getCause();
                }
                if (ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new CompletionException(ex.getCause());
            }
        }
    }
}

